/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.signalr.internal;

import android.text.TextUtils;
import donky.microsoft.aspnet.signalr.client.Action;
import donky.microsoft.aspnet.signalr.client.ConnectionState;
import donky.microsoft.aspnet.signalr.client.ErrorCallback;
import donky.microsoft.aspnet.signalr.client.LogLevel;
import donky.microsoft.aspnet.signalr.client.Logger;
import donky.microsoft.aspnet.signalr.client.Platform;
import donky.microsoft.aspnet.signalr.client.PlatformComponent;
import donky.microsoft.aspnet.signalr.client.SignalRFuture;
import donky.microsoft.aspnet.signalr.client.StateChangedCallback;
import donky.microsoft.aspnet.signalr.client.http.android.AndroidPlatformComponent;
import donky.microsoft.aspnet.signalr.client.hubs.HubConnection;
import donky.microsoft.aspnet.signalr.client.hubs.HubProxy;
import donky.microsoft.aspnet.signalr.client.hubs.SubscriptionHandler1;
import net.donky.core.DonkyException;
import net.donky.core.logging.DLog;
import net.donky.core.model.DonkyDataController;
import net.donky.core.signalr.internal.ConnectionListener;
import net.donky.core.signalr.internal.PushHandler;

public class HubConnectionFactory {
    private static final String hubName = "NetworkHub";
    private String signalRURLInUse;
    private String authTokenInUse;
    private HubConnection connection;
    private HubProxy hubProxy;
    private DLog log;
    private PushHandler pushHandler;
    private ConnectionListener connectionListener;

    public HubConnectionFactory(PushHandler pushHandler, ConnectionListener connectionListener) {
        this.pushHandler = pushHandler;
        this.connectionListener = connectionListener;
        this.log = new DLog("HubConnectionFactory");
        Platform.loadPlatformComponent((PlatformComponent)new AndroidPlatformComponent());
    }

    public void startSignalR(boolean shouldConnect) {
        String signalRURL = DonkyDataController.getInstance().getConfigurationDAO().getSignalRUrl();
        String authToken = DonkyDataController.getInstance().getConfigurationDAO().getAuthorisationToken();
        this.setupSignalRConnection(authToken, signalRURL, shouldConnect);
    }

    public void stopSignalR() {
        if (this.connection != null) {
            try {
                this.connection.stop();
            }
            catch (Exception exception) {
                this.log.warning("SignalR error when stopping. E.g. mTransport.abort can return null.");
            }
        }
    }

    public HubProxy getHubProxy() {
        return this.hubProxy;
    }

    public boolean setupSignalRConnection(String authToken, String signalRURL, boolean shouldConnect) {
        boolean newConnectionSetup = false;
        if (TextUtils.isEmpty((CharSequence)authToken) || TextUtils.isEmpty((CharSequence)signalRURL)) {
            this.log.warning("Connection require auth token and signalR url");
            return false;
        }
        if (!authToken.equals(this.authTokenInUse)) {
            this.authTokenInUse = authToken;
            newConnectionSetup = true;
        }
        if (!signalRURL.equals(this.signalRURLInUse)) {
            this.signalRURLInUse = signalRURL;
            newConnectionSetup = true;
        }
        if (newConnectionSetup && this.connection != null) {
            if (this.isConnected()) {
                this.stopSignalR();
            }
            this.createHubConnection(authToken, signalRURL, shouldConnect);
            return false;
        }
        if (this.connection == null) {
            this.createHubConnection(authToken, signalRURL, shouldConnect);
            return false;
        }
        if (this.isDisconnected() && shouldConnect) {
            this.connectSignalR();
            return false;
        }
        return true;
    }

    private void createHubConnection(String authToken, String signalRURL, boolean shouldConnect) {
        this.connection = new HubConnection(signalRURL, this.getQueryString(authToken), false, new Logger(){

            public void log(String s, LogLevel logLevel) {
                if (logLevel == LogLevel.Critical) {
                    HubConnectionFactory.this.log.error("SignalR: " + s);
                    DonkyException donkyException = new DonkyException(s);
                    HubConnectionFactory.this.connectionListener.notifyConnectionError(donkyException, null);
                } else if (logLevel == LogLevel.Information) {
                    HubConnectionFactory.this.log.debug("SignalR: " + s);
                } else if (logLevel == LogLevel.Verbose) {
                    HubConnectionFactory.this.log.debug("SignalR: " + s);
                }
            }
        });
        this.hubProxy = this.connection.createHubProxy(hubName);
        this.hubProxy.on("push", (SubscriptionHandler1)new SubscriptionHandler1<Object>(){

            public void run(Object p1) {
                HubConnectionFactory.this.log.info("SignalR: push received!");
                HubConnectionFactory.this.pushHandler.handlePush(p1);
            }
        }, Object.class);
        this.connection.connected(new Runnable(){

            @Override
            public void run() {
                HubConnectionFactory.this.log.info("SignalR: SignalR connected successfully. Connection id = " + HubConnectionFactory.this.connection.getConnectionId());
            }
        });
        this.connection.error(new ErrorCallback(){

            public void onError(Throwable error) {
                HubConnectionFactory.this.log.warning("SignalR: Hub connection error: " + error.getLocalizedMessage());
                DonkyException donkyException = new DonkyException(error.getLocalizedMessage());
                donkyException.initCause(error);
                HubConnectionFactory.this.connectionListener.notifyConnectionError(donkyException, null);
            }
        });
        this.connection.connectionSlow(new Runnable(){

            @Override
            public void run() {
                HubConnectionFactory.this.log.warning("SignalR: Hub connection slow");
            }
        });
        this.connection.stateChanged(new StateChangedCallback(){

            public void stateChanged(ConnectionState oldState, ConnectionState newState) {
                HubConnectionFactory.this.log.info("SignalR: State changed from " + oldState + " to " + newState);
                if (newState == ConnectionState.Disconnected) {
                    HubConnectionFactory.this.log.info("SignalR: Disconnected connection with id = " + HubConnectionFactory.this.connection.getConnectionId());
                }
            }
        });
        if (shouldConnect) {
            this.connectSignalR();
        }
    }

    public boolean isDisconnected() {
        return this.connection.getState() == ConnectionState.Disconnected;
    }

    public boolean isConnected() {
        if (this.connection == null) {
            return false;
        }
        return this.connection.getState() == ConnectionState.Connected;
    }

    public void connectSignalR() {
        if (this.connection != null && this.isDisconnected()) {
            SignalRFuture awaitConnection = this.connection.start();
            awaitConnection.done((Action)new Action<Void>(){

                public void run(Void obj) throws Exception {
                    HubConnectionFactory.this.log.info("SignalR: Await connection SignalRFuture done");
                }
            });
            awaitConnection.onCancelled(new Runnable(){

                @Override
                public void run() {
                    HubConnectionFactory.this.log.warning("SignalR: Await connection SignalRFuture cancelled");
                }
            });
            awaitConnection.onError(new ErrorCallback(){

                public void onError(Throwable error) {
                    HubConnectionFactory.this.log.warning("SignalR: Await connection SignalRFuture error");
                }
            });
        }
    }

    private String getQueryString(String authToken) {
        if (!TextUtils.isEmpty((CharSequence)authToken)) {
            return "access_token=" + authToken;
        }
        return "access_token=" + DonkyDataController.getInstance().getConfigurationDAO().getAuthorisationToken();
    }
}

