/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.signalr.internal.tasks;

import java.util.Map;
import net.donky.core.DonkyException;
import net.donky.core.DonkyListener;
import net.donky.core.DonkyResultListener;
import net.donky.core.signalr.internal.HubConnectionFactory;

public abstract class SignalRTask<T> {
    DonkyResultListener<T> resultListener;
    DonkyListener connectionCallbackListener;
    DonkyResultListener<T> invokeNetworkHubResultListener;
    protected static final Object sharedLock = new Object();
    protected final HubConnectionFactory hubConnectionFactory;

    public SignalRTask(HubConnectionFactory hubConnectionFactory, final DonkyResultListener<T> resultListener) {
        this.resultListener = resultListener;
        this.hubConnectionFactory = hubConnectionFactory;
        this.connectionCallbackListener = new DonkyListener(){

            public void success() {
            }

            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                if (resultListener != null) {
                    resultListener.error(donkyException, validationErrors);
                }
            }
        };
        this.invokeNetworkHubResultListener = new DonkyResultListener<T>(){

            public void success(T result) {
                if (resultListener != null) {
                    resultListener.success(result);
                }
            }

            public void error(DonkyException donkyException, Map<String, String> validationErrors) {
                if (resultListener != null) {
                    resultListener.error(donkyException, validationErrors);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConnectionError(DonkyException donkyException, Map<String, String> validationErrors) {
        Object object = sharedLock;
        synchronized (object) {
            this.connectionCallbackListener.error(donkyException, validationErrors);
            sharedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskFailed(DonkyException donkyException, Map<String, String> validationErrors) {
        Object object = sharedLock;
        synchronized (object) {
            this.invokeNetworkHubResultListener.error(donkyException, validationErrors);
            sharedLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTaskSuccessful(T result) {
        Object object = sharedLock;
        synchronized (object) {
            this.invokeNetworkHubResultListener.success(result);
            sharedLock.notifyAll();
        }
    }

    public abstract void performTask();
}

