/*
 * Decompiled with CFR 0.152.
 */
package net.donky.core.signalr.internal.tasks;

import donky.microsoft.aspnet.signalr.client.Action;
import donky.microsoft.aspnet.signalr.client.ErrorCallback;
import donky.microsoft.aspnet.signalr.client.SignalRFuture;
import java.util.List;
import net.donky.core.DonkyException;
import net.donky.core.DonkyResultListener;
import net.donky.core.network.ClientNotification;
import net.donky.core.network.restapi.secured.SynchroniseResponse;
import net.donky.core.signalr.internal.HubConnectionFactory;
import net.donky.core.signalr.internal.helpers.JsonParsingHelper;
import net.donky.core.signalr.internal.tasks.SignalRTask;

public class SynchronisationTask
extends SignalRTask<SynchroniseResponse> {
    List<ClientNotification> clientNotificationsToSend;

    public SynchronisationTask(HubConnectionFactory hubConnectionFactory, List<ClientNotification> clientNotificationsToSend, DonkyResultListener<SynchroniseResponse> resultListener) {
        super(hubConnectionFactory, resultListener);
        this.clientNotificationsToSend = clientNotificationsToSend;
    }

    @Override
    public void performTask() {
        try {
            Object[] arrayCombined = new Object[1];
            Object[] arrayClient = new Object[this.clientNotificationsToSend.size()];
            for (int i = 0; i < arrayClient.length; ++i) {
                arrayClient[i] = JsonParsingHelper.convertJSONObjectToMap(this.clientNotificationsToSend.get(i).getJson());
            }
            arrayCombined[0] = arrayClient;
            SignalRFuture signalRFuture = this.hubConnectionFactory.getHubProxy().invoke(SynchroniseResponse.class, "synchronise", arrayCombined);
            signalRFuture.done((Action)new Action<SynchroniseResponse>(){

                public void run(SynchroniseResponse response) throws Exception {
                    SynchronisationTask.this.notifyTaskSuccessful(response);
                }
            });
            signalRFuture.onError(new ErrorCallback(){

                public void onError(Throwable error) {
                    DonkyException donkyException = new DonkyException("SignalR synchronisation error");
                    donkyException.initCause(error);
                    SynchronisationTask.this.notifyTaskFailed(donkyException, null);
                }
            });
        }
        catch (Exception exception) {
            DonkyException donkyException = new DonkyException("Error invoking synchronise with signalR");
            donkyException.initCause((Throwable)exception);
            this.notifyTaskFailed(donkyException, null);
        }
    }
}

