/*
 * Decompiled with CFR 0.152.
 */
package net.dossot.jbound.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.dossot.jbound.api.Restriction;
import net.dossot.jbound.exercise.Builder;

public class Exercises {
    private final List<Builder> exercisesBuilders = new ArrayList<Builder>();

    public void run(Map<Class<?>, Object[]> customTestData) {
        for (Builder exercisesBuilder : this.exercisesBuilders) {
            exercisesBuilder.run(customTestData);
        }
    }

    protected Restriction forClass(Class<?> exercisedClass) {
        if (exercisedClass == null) {
            throw new NullPointerException("exercisedClass can not be null");
        }
        return this.forClasses(exercisedClass, new Class[0]);
    }

    protected Restriction forClasses(Class<?> exercisedClass, Class<?> ... otherExercisedClasses) {
        if (exercisedClass == null) {
            throw new NullPointerException("exercisedClass can not be null");
        }
        if (otherExercisedClasses == null) {
            throw new NullPointerException("otherExercisedClasses can not be null");
        }
        ArrayList exercisedClasses = new ArrayList();
        exercisedClasses.add(exercisedClass);
        exercisedClasses.addAll(Arrays.asList(otherExercisedClasses));
        Builder builder = new Builder(exercisedClasses);
        this.exercisesBuilders.add(builder);
        return builder;
    }
}

