/*
 * Decompiled with CFR 0.152.
 */
package net.dossot.jbound.exercise;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dossot.jbound.api.EXERCISE;
import net.dossot.jbound.api.Restriction;
import net.dossot.jbound.exercise.Runner;

public final class Builder
implements Restriction {
    private final List<Class<?>> exercisedClasses;
    private final Set<EXERCISE> skipped;
    private final Set<String> accepted;

    public Builder(List<Class<?>> exercisedClasses) {
        this.exercisedClasses = exercisedClasses;
        this.skipped = EnumSet.noneOf(EXERCISE.class);
        this.accepted = new HashSet<String>();
    }

    @Override
    public Restriction skipping(EXERCISE ... exercises) {
        if (exercises == null) {
            throw new NullPointerException("Null is not valid for exercises");
        }
        this.skipped.addAll(Arrays.asList(exercises));
        return this;
    }

    public void run(Map<Class<?>, Object[]> customTestData) {
        new Runner(this.exercisedClasses, this.skipped, this.accepted, customTestData).run();
    }

    @Override
    public Restriction acceptingGenericExceptionsFrom(String ... accessibleSignatures) {
        if (accessibleSignatures == null) {
            throw new NullPointerException("Null is not valid for accessibleSignatures");
        }
        this.accepted.addAll(Arrays.asList(accessibleSignatures));
        return null;
    }
}

