/*
 * Decompiled with CFR 0.152.
 */
package net.dossot.jbound.exercise;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dossot.jbound.exercise.Support;

final class Data {
    private static final Map<Class<?>, Object[]> TEST_DATA = new HashMap();

    private Data() {
        throw new UnsupportedOperationException();
    }

    static Object[] getTestDataFor(Class<?> targetClass) {
        Object[] testValues = TEST_DATA.get(targetClass);
        if (testValues == null && targetClass.getName().startsWith("java")) {
            System.err.println(targetClass + " is not fully supported, please report to JBound team.");
        }
        return testValues != null ? testValues : TEST_DATA.get(Object.class);
    }

    private static Class<?> getWrapperClassFor(Class<?> primitiveClass) {
        if (primitiveClass.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (primitiveClass.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (primitiveClass.equals(Character.TYPE)) {
            return Character.class;
        }
        if (primitiveClass.equals(Double.TYPE)) {
            return Double.class;
        }
        if (primitiveClass.equals(Float.TYPE)) {
            return Float.class;
        }
        if (primitiveClass.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (primitiveClass.equals(Long.TYPE)) {
            return Long.class;
        }
        if (primitiveClass.equals(Short.TYPE)) {
            return Short.class;
        }
        return null;
    }

    static {
        TEST_DATA.put(Object.class, new Object[]{null});
        TEST_DATA.put(Class.class, new Class[]{null});
        TEST_DATA.put(Boolean.TYPE, new Object[]{true, false});
        TEST_DATA.put(Byte.TYPE, new Object[]{(byte)-128, (byte)127});
        TEST_DATA.put(Character.TYPE, new Object[]{Character.valueOf('\u0000'), Character.valueOf('\uffff')});
        TEST_DATA.put(Double.TYPE, new Object[]{Double.MIN_VALUE, Double.MAX_VALUE});
        TEST_DATA.put(Float.TYPE, new Object[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)});
        TEST_DATA.put(Integer.TYPE, new Object[]{Integer.MIN_VALUE, Integer.MAX_VALUE});
        TEST_DATA.put(Long.TYPE, new Object[]{Long.MIN_VALUE, Long.MAX_VALUE});
        TEST_DATA.put(Short.TYPE, new Object[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE});
        TEST_DATA.put(BigInteger.class, new BigInteger[]{null, BigInteger.ZERO});
        TEST_DATA.put(BigDecimal.class, new BigDecimal[]{null, BigDecimal.ZERO});
        TEST_DATA.put(String.class, new String[]{null, "", " "});
        TEST_DATA.put(Date.class, new Date[]{null, new Date(Long.MIN_VALUE), new Date(Long.MAX_VALUE)});
        TEST_DATA.put(Currency.class, new Currency[]{null});
        TEST_DATA.put(RoundingMode.class, (Object[])new RoundingMode[]{null, RoundingMode.UNNECESSARY});
        Calendar minCalendar = Calendar.getInstance();
        minCalendar.setTimeInMillis(Long.MIN_VALUE);
        Calendar maxCalendar = Calendar.getInstance();
        maxCalendar.setTimeInMillis(Long.MAX_VALUE);
        TEST_DATA.put(Calendar.class, new Calendar[]{null, minCalendar, maxCalendar});
        TEST_DATA.put(Timestamp.class, new Timestamp[]{null, new Timestamp(minCalendar.getTimeInMillis()), new Timestamp(maxCalendar.getTimeInMillis())});
        TEST_DATA.put(List.class, new List[]{null, Collections.EMPTY_LIST});
        TEST_DATA.put(Set.class, new Set[]{null, Collections.EMPTY_SET});
        TEST_DATA.put(Map.class, new Map[]{null, Collections.EMPTY_MAP});
        TEST_DATA.put(Collection.class, TEST_DATA.get(List.class));
        HashMap wrappedTestData = new HashMap();
        for (Map.Entry<Class<?>, Object[]> testValueEntry : TEST_DATA.entrySet()) {
            Class<?> wrapperClass;
            Class<?> testClass = testValueEntry.getKey();
            if (!testClass.isPrimitive() || (wrapperClass = Data.getWrapperClassFor(testClass)) == null) continue;
            Object[] testValues = testValueEntry.getValue();
            int testValuesCount = Array.getLength(testValues);
            Object[] wrappedTestValues = new Object[1 + testValuesCount];
            wrappedTestValues[0] = null;
            try {
                Constructor<?> constructor = wrapperClass.getConstructor(testClass);
                for (int i = 0; i < testValuesCount; ++i) {
                    wrappedTestValues[1 + i] = constructor.newInstance(Array.get(testValues, i));
                }
            }
            catch (Exception e) {
                Support.handleInternalException(e);
            }
            wrappedTestData.put(wrapperClass, wrappedTestValues);
        }
        TEST_DATA.putAll(wrappedTestData);
    }
}

