/*
 * Decompiled with CFR 0.152.
 */
package net.dossot.jbound.exercise;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.dossot.jbound.api.EXERCISE;
import net.dossot.jbound.exercise.Data;
import net.dossot.jbound.exercise.Support;

final class Runner
implements Runnable {
    private final Set<String> accepted;
    private final List<Class<?>> exercisedClasses;
    private final Set<EXERCISE> skipped;
    private final Map<Class<?>, Object[]> customTestData;

    public Runner(List<Class<?>> exercisedClasses, Set<EXERCISE> skipped, Set<String> accepted, Map<Class<?>, Object[]> customTestData) {
        this.exercisedClasses = exercisedClasses;
        this.skipped = skipped;
        this.accepted = accepted;
        this.customTestData = customTestData;
    }

    private void acceptOrRethrow(AccessibleObject context, InvocationTargetException ite) {
        Throwable iteCause = ite.getCause();
        if (iteCause == null) {
            ite.printStackTrace();
            return;
        }
        if (iteCause.getMessage() != null) {
            return;
        }
        String contextAsString = context.toString();
        if (this.accepted.contains(contextAsString)) {
            return;
        }
        AssertionError assertionError = new AssertionError((Object)("Received a generic " + iteCause.getClass() + " when calling: " + contextAsString));
        ((Throwable)((Object)assertionError)).initCause(iteCause);
        throw assertionError;
    }

    private List<Object> newInstancesFrom(Constructor<?> constructor, List<Object> parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (parameters.size() >= constructor.getParameterTypes().length) {
            Object newInstance = this.instantiateClass(constructor, parameters);
            if (newInstance != null) {
                result.add(newInstance);
            }
        } else {
            Class<?> parameterType = constructor.getParameterTypes()[parameters.size()];
            for (Object testValue : this.getTestDataFor(parameterType)) {
                ArrayList<Object> nextParameters = new ArrayList<Object>(parameters);
                nextParameters.add(testValue);
                result.addAll(this.newInstancesFrom(constructor, nextParameters));
            }
        }
        return result;
    }

    private Object instantiateClass(Constructor<?> constructor, List<Object> parameters) {
        try {
            return constructor.newInstance(parameters.toArray());
        }
        catch (IllegalArgumentException e) {
            Support.handleInternalException(e);
        }
        catch (InstantiationException e) {
            Support.handleInternalException(e);
        }
        catch (IllegalAccessException e) {
            Support.handleInternalException(e);
        }
        catch (InvocationTargetException e) {
            this.acceptOrRethrow(constructor, e);
        }
        return null;
    }

    private List<Object> newInstancesOf(Class<?> exercisedClass) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Constructor<?> constructor : exercisedClass.getConstructors()) {
            result.addAll(this.newInstancesFrom(constructor, new ArrayList<Object>()));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void run() {
        for (Class<?> exercisedClass : this.exercisedClasses) {
            this.exerciseClass(exercisedClass);
        }
    }

    private void exerciseClass(Class<?> exercisedClass) {
        System.out.println("Exercising class: " + exercisedClass);
        this.exerciseObjects(exercisedClass, this.newInstancesOf(exercisedClass));
    }

    private void exerciseObjects(Class<?> exercisedClass, List<Object> exercisedObjects) {
        for (Object exercisedObject : exercisedObjects) {
            this.exerciseObject(exercisedClass, exercisedObjects, exercisedObject);
        }
    }

    private void exerciseObject(Class<?> exercisedClass, List<Object> exercisedObjects, Object exercisedObject) {
        this.exerciseEquals(exercisedObjects, exercisedObject);
        this.exerciseHashCode(exercisedObject);
        this.exerciseToString(exercisedObject);
        this.exerciseBeanProperties(exercisedClass, exercisedObject);
    }

    private void exerciseBeanProperties(Class<?> exercisedClass, Object exercisedObject) {
        if (!this.skipped.contains((Object)EXERCISE.BEAN_PROPERTIES)) {
            try {
                PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(exercisedClass).getPropertyDescriptors();
                if (propertyDescriptors != null) {
                    this.exerciseBeanProperties(exercisedObject, propertyDescriptors);
                }
            }
            catch (IntrospectionException e) {
                Support.handleInternalException(e);
            }
        }
    }

    private void exerciseBeanProperties(Object exercisedObject, PropertyDescriptor[] propertyDescriptors) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            this.exercisedReadMethod(exercisedObject, propertyDescriptor);
            this.exercisedWriteMethod(exercisedObject, propertyDescriptor);
        }
    }

    private void exercisedWriteMethod(Object exercisedObject, PropertyDescriptor propertyDescriptor) {
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod != null) {
            Class<?> setterParameterClass = writeMethod.getParameterTypes()[0];
            for (Object testValue : this.getTestDataFor(setterParameterClass)) {
                try {
                    writeMethod.invoke(exercisedObject, testValue);
                }
                catch (IllegalAccessException e) {
                    Support.handleInternalException(e);
                }
                catch (IllegalArgumentException e) {
                    Support.handleInternalException(e);
                }
                catch (InvocationTargetException e) {
                    this.acceptOrRethrow(writeMethod, e);
                }
            }
        }
    }

    private Object[] getTestDataFor(Class<?> targetClass) {
        Object[] testData = this.customTestData.get(targetClass);
        if (testData != null) {
            return testData;
        }
        return Data.getTestDataFor(targetClass);
    }

    private void exercisedReadMethod(Object exercisedObject, PropertyDescriptor propertyDescriptor) {
        Method readMethod = propertyDescriptor.getReadMethod();
        if (readMethod != null) {
            try {
                readMethod.invoke(exercisedObject, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                Support.handleInternalException(e);
            }
            catch (InvocationTargetException e) {
                this.acceptOrRethrow(readMethod, e);
            }
            catch (IllegalAccessException e) {
                Support.handleInternalException(e);
            }
        }
    }

    private void exerciseToString(Object exercisedObject) {
        if (!this.skipped.contains((Object)EXERCISE.TO_STRING)) {
            exercisedObject.toString();
        }
    }

    private void exerciseHashCode(Object exercisedObject) {
        if (!this.skipped.contains((Object)EXERCISE.HASHCODE)) {
            exercisedObject.hashCode();
        }
    }

    private void exerciseEquals(List<Object> exercisedObjects, Object exercisedObject) {
        if (!this.skipped.contains((Object)EXERCISE.EQUALS)) {
            exercisedObject.equals(null);
            exercisedObject.equals(new Object());
            for (Object exercisedObjectBis : exercisedObjects) {
                exercisedObject.equals(exercisedObjectBis);
            }
        }
    }
}

