/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.jfinal.kit.HttpKit;
import com.jfinal.kit.Prop;
import com.jfinal.kit.PropKit;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import java.util.HashMap;
import java.util.Map;
import net.dreamlu.api.util.HttpKitExt;

public abstract class Oauth {
    protected final Log LOGGER = Log.getLog(this.getClass());
    private static transient Prop prop = PropKit.use((String)"oauth.properties");
    private String clientId;
    private String clientSecret;
    private String redirectUri;

    public Oauth() {
        String name = this.getSelf().getClass().getSimpleName();
        name = StrKit.firstCharToLowerCase((String)name);
        this.clientId = prop.get(name + ".openid");
        this.clientSecret = prop.get(name + ".openkey");
        this.redirectUri = prop.get(name + ".redirect");
    }

    public abstract Oauth getSelf();

    protected String getAuthorizeUrl(String authorize, String state) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("response_type", "code");
        params.put("client_id", this.getClientId());
        params.put("redirect_uri", this.getRedirectUri());
        if (StrKit.notBlank((String)state)) {
            params.put("state", state);
        }
        return HttpKitExt.initParams(authorize, params);
    }

    protected String doPost(String url, Map<String, String> params) {
        return HttpKit.post((String)url, (String)HttpKitExt.map2Url(params));
    }

    protected String doGet(String url, Map<String, String> params) {
        return HttpKit.get((String)url, params);
    }

    protected String doGetWithHeaders(String url, Map<String, String> headers) {
        return HttpKit.get((String)url, null, headers);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }
}

