/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.TokenUtil;

public class OauthBaidu
extends Oauth {
    private static final String AUTH_URL = "https://openapi.baidu.com/oauth/2.0/authorize";
    private static final String TOKEN_URL = "https://openapi.baidu.com/oauth/2.0/token";
    private static final String USER_INFO_URL = "https://openapi.baidu.com/rest/2.0/passport/users/getInfo";
    private static OauthBaidu oauthBaidu = new OauthBaidu();

    private OauthBaidu() {
    }

    public static OauthBaidu me() {
        return oauthBaidu;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = TokenUtil.getAccessToken(super.doPost(TOKEN_URL, params));
        this.LOGGER.debug(token);
        return token;
    }

    public String getUserInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        return super.doPost(USER_INFO_URL, params);
    }

    public JSONObject getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        if (StrKit.isBlank((String)accessToken)) {
            throw new RuntimeException("accessToken is Blank!");
        }
        String userInfo = this.getUserInfo(accessToken);
        JSONObject dataMap = JSON.parseObject((String)userInfo);
        dataMap.put("access_token", (Object)accessToken);
        return dataMap;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

