/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.TokenUtil;

public class OauthDouban
extends Oauth {
    private static final String AUTH_URL = "https://www.douban.com/service/auth2/auth";
    private static final String TOKEN_URL = "https://www.douban.com/service/auth2/token";
    private static final String USER_INFO_URL = "https://api.douban.com/v2/user/~me";
    private static OauthDouban oauthDouban = new OauthDouban();

    private OauthDouban() {
    }

    public static OauthDouban me() {
        return oauthDouban;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = TokenUtil.getAccessToken(super.doPost(TOKEN_URL, params));
        this.LOGGER.debug(token);
        return token;
    }

    public JSONObject getUserInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Authorization", "Bearer " + accessToken);
        String userInfo = super.doGetWithHeaders(USER_INFO_URL, params);
        JSONObject dataMap = JSON.parseObject((String)userInfo);
        this.LOGGER.debug(dataMap.toJSONString());
        return dataMap;
    }

    public JSONObject getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        if (StrKit.isBlank((String)accessToken)) {
            throw new RuntimeException("accessToken is Blank!");
        }
        JSONObject dataMap = this.getUserInfo(accessToken);
        dataMap.put("access_token", (Object)accessToken);
        return dataMap;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

