/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.TokenUtil;

public class OauthOsc
extends Oauth {
    private static final String AUTH_URL = "http://www.oschina.net/action/oauth2/authorize";
    private static final String TOKEN_URL = "http://www.oschina.net/action/openapi/token";
    private static final String USER_INFO_URL = "http://www.oschina.net/action/openapi/user";
    private static final String TWEET_PUB = "http://www.oschina.net/action/openapi/tweet_pub";
    private static OauthOsc oauthOsc = new OauthOsc();

    private OauthOsc() {
    }

    public static OauthOsc me() {
        return oauthOsc;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = TokenUtil.getAccessToken(super.doGet(TOKEN_URL, params));
        this.LOGGER.debug(token);
        return token;
    }

    public JSONObject getUserInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        String userInfo = super.doGet(USER_INFO_URL, params);
        JSONObject dataMap = JSON.parseObject((String)userInfo);
        this.LOGGER.debug(dataMap.toJSONString());
        return dataMap;
    }

    public JSONObject tweetPub(String accessToken, String msg) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("msg", msg);
        return JSON.parseObject((String)super.doPost(TWEET_PUB, params));
    }

    public JSONObject getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        if (StrKit.isBlank((String)accessToken)) {
            throw new RuntimeException("accessToken is Blank!");
        }
        JSONObject dataMap = this.getUserInfo(accessToken);
        dataMap.put("access_token", (Object)accessToken);
        return dataMap;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

