/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.TokenUtil;

public class OauthQQ
extends Oauth {
    private static final String AUTH_URL = "https://graph.qq.com/oauth2.0/authorize";
    private static final String TOKEN_URL = "https://graph.qq.com/oauth2.0/token";
    private static final String TOKEN_INFO_URL = "https://graph.qq.com/oauth2.0/me";
    private static final String USER_INFO_URL = "https://graph.qq.com/user/get_user_info";
    private static OauthQQ oauthQQ = new OauthQQ();

    private OauthQQ() {
    }

    public static OauthQQ me() {
        return oauthQQ;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = TokenUtil.getAccessToken(super.doGet(TOKEN_URL, params));
        this.LOGGER.debug(token);
        return token;
    }

    public String getTokenInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        String openid = TokenUtil.getOpenId(super.doGet(TOKEN_INFO_URL, params));
        this.LOGGER.debug(openid);
        return openid;
    }

    public String getUserInfo(String accessToken, String uid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("oauth_consumer_key", this.getClientId());
        params.put("openid", uid);
        params.put("format", "json");
        String userinfo = super.doGet(USER_INFO_URL, params);
        this.LOGGER.debug(userinfo);
        return userinfo;
    }

    public JSONObject getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        if (StrKit.isBlank((String)accessToken)) {
            throw new RuntimeException("accessToken is Blank!");
        }
        String openId = this.getTokenInfo(accessToken);
        if (StrKit.isBlank((String)openId)) {
            throw new RuntimeException("openId is Blank!");
        }
        JSONObject dataMap = JSON.parseObject((String)this.getUserInfo(accessToken, openId));
        dataMap.put("openid", (Object)openId);
        dataMap.put("access_token", (Object)accessToken);
        return dataMap;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

