/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;

public class OauthRenren
extends Oauth {
    private static final String AUTH_URL = "https://graph.renren.com/oauth/authorize";
    private static final String TOKEN_URL = "https://graph.renren.com/oauth/token";
    private static OauthRenren oauthRenren = new OauthRenren();

    private OauthRenren() {
    }

    public static OauthRenren me() {
        return oauthRenren;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    private String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = super.doPost(TOKEN_URL, params);
        this.LOGGER.debug(token);
        return token;
    }

    public JSONObject getUserInfoByCode(String code) {
        String tokenInfo = this.getTokenByCode(code);
        if (StrKit.isBlank((String)tokenInfo)) {
            throw new RuntimeException("Token is Blank!");
        }
        JSONObject json = JSONObject.parseObject((String)tokenInfo);
        String access_token = json.getString("access_token");
        if (StrKit.isBlank((String)access_token)) {
            throw new RuntimeException("Token is Blank!");
        }
        JSONObject userJson = json.getJSONObject("user");
        userJson.put("access_token", (Object)access_token);
        return userJson;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

