/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.TokenUtil;

public class OauthSina
extends Oauth {
    private static final String AUTH_URL = "https://api.weibo.com/oauth2/authorize";
    private static final String TOKEN_URL = "https://api.weibo.com/oauth2/access_token";
    private static final String TOKEN_INFO_URL = "https://api.weibo.com/oauth2/get_token_info";
    private static final String USER_INFO_URL = "https://api.weibo.com/2/users/show.json";
    private static OauthSina oauthSina = new OauthSina();

    private OauthSina() {
    }

    public static OauthSina me() {
        return oauthSina;
    }

    public String getAuthorizeUrl(String state) {
        return super.getAuthorizeUrl(AUTH_URL, state);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("client_id", this.getClientId());
        params.put("client_secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        params.put("redirect_uri", this.getRedirectUri());
        String token = TokenUtil.getAccessToken(super.doPost(TOKEN_URL, params));
        this.LOGGER.debug(token);
        return token;
    }

    public String getTokenInfo(String accessToken) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        String jsonStr = super.doPost(TOKEN_INFO_URL, params);
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        String openid = json.getString("uid");
        this.LOGGER.debug(openid);
        return openid;
    }

    public String getUserInfo(String accessToken, String uid) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uid", uid);
        params.put("access_token", accessToken);
        String userInfo = super.doGet(USER_INFO_URL, params);
        this.LOGGER.debug(userInfo);
        return userInfo;
    }

    public JSONObject getUserInfoByCode(String code) {
        String accessToken = this.getTokenByCode(code);
        if (StrKit.isBlank((String)accessToken)) {
            throw new RuntimeException("Token is Blank!");
        }
        String uid = this.getTokenInfo(accessToken);
        if (StrKit.isBlank((String)uid)) {
            throw new RuntimeException("accessToken is Blank!");
        }
        JSONObject dataMap = JSON.parseObject((String)this.getUserInfo(accessToken, uid));
        dataMap.put("access_token", (Object)accessToken);
        return dataMap;
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

