/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.api.oauth;

import com.jfinal.kit.StrKit;
import java.util.HashMap;
import net.dreamlu.api.oauth.Oauth;
import net.dreamlu.api.util.HttpKitExt;

public class OauthWeixin
extends Oauth {
    private static final String AUTH_URL = "https://open.weixin.qq.com/connect/qrconnect";
    private static final String TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";
    private static final String USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo";
    private static OauthWeixin oauthWeixin = new OauthWeixin();

    private OauthWeixin() {
    }

    public static OauthWeixin me() {
        return oauthWeixin;
    }

    public String getAuthorizeUrl(String state) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appid", this.getClientId());
        params.put("response_type", "code");
        params.put("redirect_uri", this.getRedirectUri());
        params.put("scope", "snsapi_login");
        if (StrKit.isBlank((String)state)) {
            params.put("state", "wx#wechat_redirect");
        } else {
            params.put("state", state.concat("#wechat_redirect"));
        }
        return HttpKitExt.initParams(AUTH_URL, params);
    }

    public String getTokenByCode(String code) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", code);
        params.put("appid", this.getClientId());
        params.put("secret", this.getClientSecret());
        params.put("grant_type", "authorization_code");
        return super.doPost(TOKEN_URL, params);
    }

    public String getUserInfo(String accessToken, String openId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("openid", openId);
        return super.doPost(USER_INFO_URL, params);
    }

    @Override
    public Oauth getSelf() {
        return this;
    }
}

