/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

import com.alibaba.fastjson.JSONObject;
import com.baidu.ueditor.ConfigManager;
import com.baidu.ueditor.UeditorConfigKit;
import com.baidu.ueditor.define.ActionMap;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.hunter.ImageHunter;
import com.baidu.ueditor.upload.Uploader;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ActionEnter {
    private ConfigManager configManager = ConfigManager.getInstance();
    private static final ActionEnter me = new ActionEnter();

    private ActionEnter() {
    }

    public static ActionEnter me() {
        return me;
    }

    public String exec(HttpServletRequest request) {
        String callbackName = request.getParameter("callback");
        if (callbackName != null) {
            if (!this.validCallbackName(callbackName)) {
                return new BaseState(false, 401).toJSONString();
            }
            return callbackName + "(" + this.invoke(request) + ");";
        }
        return this.invoke(request);
    }

    private String invoke(HttpServletRequest request) {
        String actionType = request.getParameter("action");
        String rootPath = request.getRealPath("/");
        String ctxPath = request.getContextPath();
        if (actionType == null || !ActionMap.mapping.containsKey(actionType)) {
            return new BaseState(false, 101).toJSONString();
        }
        if (this.configManager == null || !this.configManager.valid()) {
            return new BaseState(false, 102).toJSONString();
        }
        State state = null;
        int actionCode = ActionMap.getType(actionType);
        Map<String, Object> conf = null;
        switch (actionCode) {
            case 0: {
                JSONObject allConfig = this.configManager.getAllConfig();
                String imageUrlPrefix = allConfig.getString("imageUrlPrefix");
                String scrawlUrlPrefix = allConfig.getString("scrawlUrlPrefix");
                String snapscreenUrlPrefix = allConfig.getString("snapscreenUrlPrefix");
                String catcherUrlPrefix = allConfig.getString("catcherUrlPrefix");
                String videoUrlPrefix = allConfig.getString("videoUrlPrefix");
                String fileUrlPrefix = allConfig.getString("fileUrlPrefix");
                String imageManagerUrlPrefix = allConfig.getString("imageManagerUrlPrefix");
                String fileManagerUrlPrefix = allConfig.getString("fileManagerUrlPrefix");
                if (null == imageUrlPrefix || "".equals(imageUrlPrefix.trim())) {
                    allConfig.put("imageUrlPrefix", (Object)ctxPath);
                }
                if (null == scrawlUrlPrefix || "".equals(scrawlUrlPrefix.trim())) {
                    allConfig.put("scrawlUrlPrefix", (Object)ctxPath);
                }
                if (null == snapscreenUrlPrefix || "".equals(snapscreenUrlPrefix.trim())) {
                    allConfig.put("snapscreenUrlPrefix", (Object)ctxPath);
                }
                if (null == catcherUrlPrefix || "".equals(catcherUrlPrefix.trim())) {
                    allConfig.put("catcherUrlPrefix", (Object)ctxPath);
                }
                if (null == videoUrlPrefix || "".equals(videoUrlPrefix.trim())) {
                    allConfig.put("videoUrlPrefix", (Object)ctxPath);
                }
                if (null == fileUrlPrefix || "".equals(fileUrlPrefix.trim())) {
                    allConfig.put("fileUrlPrefix", (Object)ctxPath);
                }
                if (null == imageManagerUrlPrefix || "".equals(imageManagerUrlPrefix.trim())) {
                    allConfig.put("imageManagerUrlPrefix", (Object)ctxPath);
                }
                if (null == fileManagerUrlPrefix || "".equals(fileManagerUrlPrefix.trim())) {
                    allConfig.put("fileManagerUrlPrefix", (Object)ctxPath);
                }
                return allConfig.toJSONString();
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                conf = this.configManager.getConfig(actionCode, rootPath);
                state = new Uploader(request, conf).doExec();
                break;
            }
            case 5: {
                conf = this.configManager.getConfig(actionCode, rootPath);
                String[] list = request.getParameterValues((String)conf.get("fieldName"));
                state = new ImageHunter(conf).capture(list);
                break;
            }
            case 6: 
            case 7: {
                conf = this.configManager.getConfig(actionCode, rootPath);
                int start = this.getStartIndex(request);
                state = UeditorConfigKit.fileManager.list(conf, start);
            }
        }
        return state.toJSONString();
    }

    public int getStartIndex(HttpServletRequest request) {
        String start = request.getParameter("start");
        try {
            return Integer.parseInt(start);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public boolean validCallbackName(String name) {
        return name.matches("^[a-zA-Z_]+[\\w0-9_]*$");
    }
}

