/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.define;

import com.alibaba.fastjson.JSONObject;
import com.baidu.ueditor.Encoder;
import com.baidu.ueditor.define.AppInfo;
import com.baidu.ueditor.define.State;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiState
implements State {
    private boolean state = false;
    private String info = null;
    private Map<String, Object> infoMap = new HashMap<String, Object>();
    private List<Map<String, Object>> stateList = new ArrayList<Map<String, Object>>();

    public MultiState(boolean state) {
        this.state = state;
    }

    public MultiState(boolean state, String info) {
        this.state = state;
        this.info = info;
    }

    public MultiState(boolean state, int infoKey) {
        this.state = state;
        this.info = AppInfo.getStateInfo(infoKey);
    }

    @Override
    public boolean isSuccess() {
        return this.state;
    }

    public void addState(State state) {
        this.stateList.add(state.toJSONObject());
    }

    @Override
    public void putInfo(String name, String val) {
        this.infoMap.put(name, val);
    }

    @Override
    public Map<String, Object> toJSONObject() {
        String stateVal = this.isSuccess() ? AppInfo.getStateInfo(0) : this.info;
        this.infoMap.put("state", stateVal);
        this.infoMap.put("list", this.stateList);
        return this.infoMap;
    }

    @Override
    public String toJSONString() {
        this.toJSONObject();
        return Encoder.toUnicode(JSONObject.toJSONString(this.infoMap));
    }

    @Override
    public void putInfo(String name, long val) {
        this.infoMap.put(name, val);
    }
}

