/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.manager;

import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.MultiState;
import com.baidu.ueditor.define.State;
import com.baidu.ueditor.manager.AbstractFileManager;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class QiniuFileManager
extends AbstractFileManager {
    private final Auth auth;
    private final String bucket;
    private UploadManager uploadManager;
    private BucketManager bucketManager;

    public QiniuFileManager(String ak, String sk, String bucket) {
        this.auth = Auth.create((String)ak, (String)sk);
        this.bucket = bucket;
        this.uploadManager = new UploadManager();
        this.bucketManager = new BucketManager(this.auth);
    }

    private String getUpToken() {
        return this.auth.uploadToken(this.bucket);
    }

    private State getState(String[] keys) {
        MultiState state = new MultiState(true);
        BaseState fileState = null;
        for (String key : keys) {
            if (key == null) break;
            fileState = new BaseState(true);
            fileState.putInfo("url", key);
            state.addState(fileState);
        }
        return state;
    }

    @Override
    public State list(Map<String, Object> conf, int start) {
        String dirPath = (String)conf.get("dir");
        List<String> allowFiles = this.getAllowFiles(conf.get("allowFiles"));
        int count = (Integer)conf.get("count");
        if (dirPath.startsWith("/")) {
            dirPath = dirPath.substring(1);
        }
        BucketManager.FileListIterator it = this.bucketManager.createFileListIterator(this.bucket, dirPath, count, null);
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            FileInfo[] items;
            for (FileInfo fileInfo : items = it.next()) {
                String key = fileInfo.key;
                String ext = FilenameUtils.getExtension((String)key);
                if (!allowFiles.contains(ext)) continue;
                list.add("/" + fileInfo.key);
            }
        }
        Collections.reverse(list);
        State state = null;
        if (start < 0 || start > list.size()) {
            state = new MultiState(true);
        } else {
            String[] fileList = Arrays.copyOfRange(list.toArray(new String[0]), start, start + count);
            state = this.getState(fileList);
        }
        state.putInfo("start", start);
        state.putInfo("total", list.size());
        return state;
    }

    @Override
    public State saveFile(byte[] data, String rootPath, String savePath) {
        if (savePath.startsWith("/")) {
            savePath = savePath.substring(1);
        }
        try {
            this.uploadManager.put(data, savePath, this.getUpToken());
        }
        catch (QiniuException e) {
            return new BaseState(false, 4);
        }
        BaseState state = new BaseState(true);
        state.putInfo("size", data.length);
        state.putInfo("title", this.getFileName(savePath));
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State saveFile(InputStream is, String rootPath, String savePath, long maxSize) {
        if (savePath.startsWith("/")) {
            savePath = savePath.substring(1);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = null;
        try {
            IOUtils.copy((InputStream)is, (OutputStream)output);
            data = output.toByteArray();
            if ((long)data.length > maxSize) {
                BaseState baseState = new BaseState(false, 1);
                return baseState;
            }
            this.uploadManager.put(data, savePath, this.getUpToken());
        }
        catch (IOException e) {
            BaseState baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((InputStream)is);
        }
        BaseState state = new BaseState(true);
        state.putInfo("size", data.length);
        state.putInfo("title", this.getFileName(savePath));
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State saveFile(InputStream is, String rootPath, String savePath) {
        if (savePath.startsWith("/")) {
            savePath = savePath.substring(1);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] data = null;
        try {
            IOUtils.copy((InputStream)is, (OutputStream)output);
            data = output.toByteArray();
            this.uploadManager.put(data, savePath, this.getUpToken());
        }
        catch (IOException e) {
            BaseState baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            IOUtils.closeQuietly((OutputStream)output);
            IOUtils.closeQuietly((InputStream)is);
        }
        BaseState state = new BaseState(true);
        state.putInfo("size", data.length);
        state.putInfo("title", this.getFileName(savePath));
        return state;
    }

    private String getFileName(String savePath) {
        return FilenameUtils.getBaseName((String)savePath);
    }
}

