/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor.upload;

import com.baidu.ueditor.PathFormat;
import com.baidu.ueditor.UeditorConfigKit;
import com.baidu.ueditor.define.BaseState;
import com.baidu.ueditor.define.FileType;
import com.baidu.ueditor.define.State;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;

public class BinaryUploader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final State save(HttpServletRequest request, Map<String, Object> conf) {
        BaseState baseState;
        boolean isAjaxUpload;
        FileItemStream fileStream = null;
        boolean bl = isAjaxUpload = request.getHeader("X_Requested_With") != null;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            return new BaseState(false, 5);
        }
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        if (isAjaxUpload) {
            upload.setHeaderEncoding("UTF-8");
        }
        InputStream is = null;
        try {
            FileItemIterator iterator = upload.getItemIterator(request);
            while (iterator.hasNext() && (fileStream = iterator.next()).isFormField()) {
                fileStream = null;
            }
            if (fileStream == null) {
                BaseState baseState2 = new BaseState(false, 7);
                return baseState2;
            }
            String savePath = (String)conf.get("savePath");
            String originFileName = fileStream.getName();
            String suffix = FileType.getSuffixByFilename(originFileName);
            originFileName = originFileName.substring(0, originFileName.length() - suffix.length());
            savePath = savePath + suffix;
            long maxSize = (Long)conf.get("maxSize");
            if (!BinaryUploader.validType(suffix, (String[])conf.get("allowFiles"))) {
                BaseState baseState3 = new BaseState(false, 8);
                return baseState3;
            }
            savePath = PathFormat.parse(savePath, originFileName);
            String rootPath = (String)conf.get("rootPath");
            is = fileStream.openStream();
            State storageState = UeditorConfigKit.getFileManager().saveFile(is, rootPath, savePath, maxSize);
            if (storageState.isSuccess()) {
                storageState.putInfo("url", PathFormat.format(savePath));
                storageState.putInfo("type", suffix);
                storageState.putInfo("original", originFileName + suffix);
            }
            State state = storageState;
            IOUtils.closeQuietly((InputStream)is);
            return state;
        }
        catch (FileUploadException e) {
            baseState = new BaseState(false, 6);
            return baseState;
        }
        catch (IOException e) {
            baseState = new BaseState(false, 4);
            return baseState;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private static boolean validType(String type, String[] allowTypes) {
        List<String> list = Arrays.asList(allowTypes);
        return list.contains(type);
    }
}

