/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.factories;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.StringJoiner;
import net.dreamlu.mica.auto.common.MultiSetMap;

final class FactoriesFiles {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    static void writeFactoriesFile(MultiSetMap<String, String> factories, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        writer.write("# Generated by mica-auto www.dreamlu.net\n");
        Set<String> keySet = factories.keySet();
        for (String key : keySet) {
            Set<String> values = factories.get(key);
            if (values == null || values.isEmpty()) continue;
            writer.write(key);
            writer.write("=\\\n  ");
            StringJoiner joiner = new StringJoiner(",\\\n  ");
            for (String value : values) {
                joiner.add(value);
            }
            writer.write(joiner.toString());
            writer.newLine();
        }
        writer.flush();
        output.close();
    }

    static void writeDevToolsFile(String projectName, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        String format = "restart.include.%s=/%s[\\\\w-]+\\.jar";
        writer.write("# Generated by mica-auto www.dreamlu.net\n");
        writer.write(String.format(format, projectName, projectName));
        writer.flush();
        output.close();
    }

    private FactoriesFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

