/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.auto.factories;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import net.dreamlu.mica.auto.annotation.AutoIgnore;
import net.dreamlu.mica.auto.common.AbstractMicaProcessor;
import net.dreamlu.mica.auto.common.BootAutoType;
import net.dreamlu.mica.auto.common.MultiSetMap;
import net.dreamlu.mica.auto.factories.FactoriesFiles;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessor;
import net.ltgt.gradle.incap.IncrementalAnnotationProcessorType;

@SupportedAnnotationTypes(value={"*"})
@SupportedOptions(value={"debug"})
@AutoService(value={Processor.class})
@IncrementalAnnotationProcessor(value=IncrementalAnnotationProcessorType.AGGREGATING)
public class AutoFactoriesProcessor
extends AbstractMicaProcessor {
    private static final String FEIGN_CLIENT_ANNOTATION = "org.springframework.cloud.openfeign.FeignClient";
    private static final String FEIGN_AUTO_CONFIGURE_KEY = "net.dreamlu.mica.feign.MicaFeignAutoConfiguration";
    private static final String FACTORIES_RESOURCE_LOCATION = "META-INF/spring.factories";
    private static final String DEVTOOLS_RESOURCE_LOCATION = "META-INF/spring-devtools.properties";
    private static final String AUTO_CONFIGURATION = "org.springframework.boot.autoconfigure.AutoConfiguration";
    private static final String AUTO_CONFIGURATION_IMPORTS_LOCATION = "META-INF/spring/org.springframework.boot.autoconfigure.AutoConfiguration.imports";
    private final MultiSetMap<String, String> factories = new MultiSetMap();
    private final Set<String> autoConfigurationImportsSet = new LinkedHashSet<String>();
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    protected boolean processImpl(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateAutoConfigurationImportsFiles();
            this.generateFactoriesFiles();
        } else {
            this.processAnnotations(annotations, roundEnv);
        }
        return false;
    }

    private void processAnnotations(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log(annotations.toString());
        Set<? extends Element> elementSet = roundEnv.getRootElements();
        this.log("All Element set: " + elementSet.toString());
        Set typeElementSet = elementSet.stream().filter(this::isClassOrInterface).filter(e -> e instanceof TypeElement).map(e -> (TypeElement)e).collect(Collectors.toSet());
        if (typeElementSet.isEmpty()) {
            this.log("Annotations elementSet is isEmpty");
            return;
        }
        for (TypeElement typeElement : typeElementSet) {
            if (this.isAnnotation(this.elementUtils, typeElement, AutoIgnore.class.getName())) {
                this.log("Found @AutoIgnore annotation\uff0cignore Element: " + typeElement.toString());
                continue;
            }
            if (this.isAnnotation(this.elementUtils, typeElement, FEIGN_CLIENT_ANNOTATION)) {
                this.log("Found @FeignClient Element: " + typeElement.toString());
                ElementKind elementKind = typeElement.getKind();
                if (ElementKind.INTERFACE != elementKind) {
                    this.fatalError("@FeignClient Element " + typeElement + " \u4e0d\u662f\u63a5\u53e3\u3002");
                    continue;
                }
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e spring.factories factoryName\uff1a" + factoryName);
                this.factories.put(FEIGN_AUTO_CONFIGURE_KEY, factoryName);
                continue;
            }
            if (this.isAnnotation(this.elementUtils, typeElement, AUTO_CONFIGURATION)) {
                String autoConfigurationBeanName = typeElement.getQualifiedName().toString();
                this.autoConfigurationImportsSet.add(autoConfigurationBeanName);
                this.log("\u8bfb\u53d6\u5230\u81ea\u52a8\u914d\u7f6e @AutoConfiguration\uff1a" + autoConfigurationBeanName);
            }
            for (BootAutoType autoType : BootAutoType.values()) {
                String annotation = autoType.getAnnotation();
                if (!this.isAnnotation(this.elementUtils, typeElement, annotation)) continue;
                this.log("Found @" + annotation + " Element: " + typeElement.toString());
                String factoryName = typeElement.getQualifiedName().toString();
                if (this.factories.containsVal(factoryName)) continue;
                this.log("\u8bfb\u53d6\u5230\u65b0\u914d\u7f6e spring.factories factoryName\uff1a" + factoryName);
                this.factories.put(autoType.getConfigureKey(), factoryName);
            }
        }
    }

    private void generateFactoriesFiles() {
        if (this.factories.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            MultiSetMap<String, String> existingFactories;
            FileObject existingFactoriesFile;
            MultiSetMap<String, String> allFactories = new MultiSetMap<String, String>();
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", FACTORIES_RESOURCE_LOCATION);
                this.log("Looking for existing spring.factories file at " + existingFactoriesFile.toUri());
                existingFactories = FactoriesFiles.readFactoriesFile(existingFactoriesFile, this.elementUtils);
                this.log("Existing spring.factories entries: " + existingFactories);
                allFactories.putAll(existingFactories);
            }
            catch (IOException e) {
                this.log("spring.factories resource file not found.");
            }
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION);
                this.log("Looking for existing spring.factories file at " + existingFactoriesFile.toUri());
                existingFactories = FactoriesFiles.readFactoriesFile(existingFactoriesFile, this.elementUtils);
                this.log("Existing spring.factories entries: " + existingFactories);
                allFactories.putAll(existingFactories);
            }
            catch (IOException e) {
                this.log("spring.factories resource file did not already exist.");
            }
            allFactories.putAll(this.factories);
            this.log("New spring.factories file contents: " + allFactories);
            FileObject factoriesFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", FACTORIES_RESOURCE_LOCATION, new Element[0]);
            try (OutputStream out = factoriesFile.openOutputStream();){
                FactoriesFiles.writeFactoriesFile(allFactories, out);
            }
            String classesPath = factoriesFile.toUri().toString().split("classes")[0];
            Path projectPath = Paths.get(new URI(classesPath)).getParent();
            String projectName = projectPath.getFileName().toString();
            FileObject devToolsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", DEVTOOLS_RESOURCE_LOCATION, new Element[0]);
            try (OutputStream out = devToolsFile.openOutputStream();){
                FactoriesFiles.writeDevToolsFile(projectName, out);
            }
        }
        catch (IOException | URISyntaxException e) {
            this.fatalError(e);
        }
    }

    private void generateAutoConfigurationImportsFiles() {
        if (this.autoConfigurationImportsSet.isEmpty()) {
            return;
        }
        Filer filer = this.processingEnv.getFiler();
        try {
            Set<String> existingSet;
            FileObject existingFactoriesFile;
            LinkedHashSet<String> allAutoConfigurationImports = new LinkedHashSet<String>();
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", AUTO_CONFIGURATION_IMPORTS_LOCATION);
                this.log("Looking for existing AutoConfiguration imports file at " + existingFactoriesFile.toUri());
                existingSet = FactoriesFiles.readAutoConfigurationImports(existingFactoriesFile);
                this.log("Existing AutoConfiguration imports entries: " + existingSet);
                allAutoConfigurationImports.addAll(existingSet);
            }
            catch (IOException e) {
                this.log("AutoConfiguration imports resource file not found.");
            }
            try {
                existingFactoriesFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", AUTO_CONFIGURATION_IMPORTS_LOCATION);
                this.log("Looking for existing AutoConfiguration imports file at " + existingFactoriesFile.toUri());
                existingSet = FactoriesFiles.readAutoConfigurationImports(existingFactoriesFile);
                this.log("Existing AutoConfiguration imports entries: " + existingSet);
                allAutoConfigurationImports.addAll(existingSet);
            }
            catch (IOException e) {
                this.log("AutoConfiguration imports resource file did not already exist.");
            }
            allAutoConfigurationImports.addAll(this.autoConfigurationImportsSet);
            this.log("New AutoConfiguration imports file contents: " + allAutoConfigurationImports);
            FileObject autoConfigurationImportsFile = filer.createResource(StandardLocation.CLASS_OUTPUT, "", AUTO_CONFIGURATION_IMPORTS_LOCATION, new Element[0]);
            try (OutputStream out = autoConfigurationImportsFile.openOutputStream();){
                FactoriesFiles.writeAutoConfigurationImportsFile(allAutoConfigurationImports, out);
            }
        }
        catch (IOException e) {
            this.fatalError(e);
        }
    }
}

