/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.common.error;

import java.util.Set;
import javax.validation.ConstraintViolation;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;

public abstract class BaseExceptionTranslator {
    protected R<Object> handleError(BindingResult result) {
        FieldError error = result.getFieldError();
        String message = String.format("%s:%s", error.getField(), error.getDefaultMessage());
        return R.fail((IResultCode)SystemCode.PARAM_BIND_ERROR, (String)message);
    }

    protected R<Object> handleError(Set<ConstraintViolation<?>> violations) {
        ConstraintViolation<?> violation = violations.iterator().next();
        String path = ((PathImpl)violation.getPropertyPath()).getLeafNode().getName();
        String message = String.format("%s:%s", path, violation.getMessage());
        return R.fail((IResultCode)SystemCode.PARAM_VALID_ERROR, (String)message);
    }
}

