/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.config;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import net.dreamlu.mica.common.error.MicaErrorEvent;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.props.MicaAsyncProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@EnableScheduling
@Configuration
public class MicaExecutorConfiguration
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(MicaExecutorConfiguration.class);
    private final MicaAsyncProperties properties;
    private final ApplicationEventPublisher publisher;

    @Bean(name={"taskExecutor"})
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(this.properties.getCorePoolSize());
        executor.setMaxPoolSize(this.properties.getMaxPoolSize());
        executor.setQueueCapacity(this.properties.getQueueCapacity());
        executor.setKeepAliveSeconds(this.properties.getKeepAliveSeconds());
        executor.setThreadNamePrefix("mica-async-executor-");
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return new MicaAsyncUncaughtExceptionHandler(this.publisher);
    }

    public MicaExecutorConfiguration(MicaAsyncProperties properties, ApplicationEventPublisher publisher) {
        this.properties = properties;
        this.publisher = publisher;
    }

    private static class MicaAsyncUncaughtExceptionHandler
    implements AsyncUncaughtExceptionHandler {
        private final ApplicationEventPublisher eventPublisher;

        public void handleUncaughtException(Throwable error, Method method, Object ... params) {
            log.error("Unexpected exception occurred invoking async method: {}", (Object)method, (Object)error);
            MicaErrorEvent event = new MicaErrorEvent();
            event.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
            event.setExceptionName(error.getClass().getName());
            event.setMessage(error.getMessage());
            event.setCreatedAt(LocalDateTime.now());
            Object[] elements = error.getStackTrace();
            if (ObjectUtil.isNotEmpty((Object[])elements)) {
                Object element = elements[0];
                event.setClassName(((StackTraceElement)element).getClassName());
                event.setFileName(((StackTraceElement)element).getFileName());
                event.setMethodName(((StackTraceElement)element).getMethodName());
                event.setLineNumber(((StackTraceElement)element).getLineNumber());
            }
            this.eventPublisher.publishEvent((Object)event);
        }

        public MicaAsyncUncaughtExceptionHandler(ApplicationEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
        }
    }
}

