/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.config;

import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.props.MicaRequestLogProperties;
import net.dreamlu.mica.reactive.logger.ReactiveRequestLogFilter;
import net.dreamlu.mica.reactive.logger.RequestLogExclusiveRule;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.AntPathMatcher;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(value={"mica.log.request.enabled"}, havingValue="true", matchIfMissing=true)
public class MicaRequestLogConfiguration {
    private final MicaRequestLogProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public ReactiveRequestLogFilter reactiveRequestLogFilter(RequestLogExclusiveRule exclusiveRule) {
        return new ReactiveRequestLogFilter(this.properties, exclusiveRule);
    }

    public MicaRequestLogConfiguration(MicaRequestLogProperties properties) {
        this.properties = properties;
    }

    @Configuration
    @ConditionalOnClass(value={WebEndpointProperties.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class WebEndpointRequestLogExclusiveRule
    extends DefaultRequestLogExclusiveRule {
        private static final String STATIC_PATH_PATTERN = "/**";
        private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
        private final WebEndpointProperties properties;
        private final WebFluxProperties webFluxProperties;

        @Override
        public boolean excluded(String path) {
            String actuatorBasePath = this.properties.getBasePath();
            if (StringUtil.isNotBlank((CharSequence)actuatorBasePath) && path.startsWith(actuatorBasePath)) {
                return true;
            }
            String staticPathPattern = this.webFluxProperties.getStaticPathPattern();
            if (!STATIC_PATH_PATTERN.equals(staticPathPattern) && PATH_MATCHER.match(staticPathPattern, path)) {
                return true;
            }
            return super.excluded(path);
        }

        public WebEndpointRequestLogExclusiveRule(WebEndpointProperties properties, WebFluxProperties webFluxProperties) {
            this.properties = properties;
            this.webFluxProperties = webFluxProperties;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={RequestLogExclusiveRule.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public static class DefaultRequestLogExclusiveRule
    implements RequestLogExclusiveRule {
        @Override
        public boolean excluded(String path) {
            return path.contains(".") && !path.toLowerCase().endsWith(".json");
        }
    }
}

