/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.context;

import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class ReactiveRequestContextHolder {
    private static final Class<ServerWebExchange> CONTEXT_KEY = ServerWebExchange.class;

    public static Mono<ServerWebExchange> getExchange() {
        return Mono.subscriberContext().map(ctx -> (ServerWebExchange)ctx.get(CONTEXT_KEY));
    }

    public static Mono<ServerHttpRequest> getRequest() {
        return ReactiveRequestContextHolder.getExchange().map(ServerWebExchange::getRequest);
    }

    public static Context put(Context context, ServerWebExchange exchange) {
        return context.put(CONTEXT_KEY, (Object)exchange);
    }
}

