/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.error;

import java.util.Optional;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class MicaErrorWebExceptionHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(MicaErrorWebExceptionHandler.class);

    public MicaErrorWebExceptionHandler(ErrorAttributes attributes, ResourceProperties properties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(attributes, properties, errorProperties, applicationContext);
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), this::renderErrorResponse);
    }

    protected Mono<ServerResponse> renderErrorResponse(ServerRequest request) {
        R result;
        Throwable error = this.getError(request);
        HttpStatus status = this.determineHttpStatus(error);
        MultiValueMap queryParams = request.queryParams();
        String requestUrl = UriComponentsBuilder.fromPath((String)request.path()).queryParams(queryParams).build().toUriString();
        if (HttpStatus.NOT_FOUND == status) {
            log.error("URL:{} error status:{}", (Object)requestUrl, (Object)status.value());
        } else {
            log.error("URL:{} error status:{}", new Object[]{requestUrl, status.value(), error});
        }
        String message = status.value() + ":" + status.getReasonPhrase();
        if (error instanceof ServiceException) {
            result = ((ServiceException)error).getResult();
            result = Optional.ofNullable(result).orElse(R.fail((IResultCode)SystemCode.FAILURE));
        } else {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)message);
        }
        return ServerResponse.status((HttpStatus)status).contentType(MediaType.APPLICATION_JSON_UTF8).body(BodyInserters.fromObject((Object)result));
    }

    private HttpStatus determineHttpStatus(Throwable error) {
        if (error instanceof ResponseStatusException) {
            return ((ResponseStatusException)error).getStatus();
        }
        ResponseStatus responseStatus = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(error.getClass(), ResponseStatus.class);
        return responseStatus != null ? responseStatus.code() : HttpStatus.INTERNAL_SERVER_ERROR;
    }
}

