/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.error;

import java.time.LocalDateTime;
import net.dreamlu.mica.common.error.MicaErrorEvent;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.reactive.context.ReactiveRequestContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Order
@Configuration
@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class MicaExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(MicaExceptionTranslator.class);
    private final ApplicationEventPublisher publisher;

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<R<Object>> handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        R result = e.getResult();
        if (result != null) {
            return Mono.just((Object)result);
        }
        return ReactiveRequestContextHolder.getRequest().doOnSuccess(r -> this.publishEvent((ServerHttpRequest)r, (Throwable)e)).flatMap(r -> Mono.just((Object)R.fail((IResultCode)SystemCode.FAILURE, (String)e.getMessage())));
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Mono<R<Object>> handleError(Throwable e) {
        log.error("\u672a\u77e5\u5f02\u5e38", e);
        return ReactiveRequestContextHolder.getRequest().doOnSuccess(r -> this.publishEvent((ServerHttpRequest)r, e)).flatMap(r -> Mono.just((Object)R.fail((IResultCode)SystemCode.FAILURE)));
    }

    private void publishEvent(ServerHttpRequest request, Throwable error) {
        MicaErrorEvent event = new MicaErrorEvent();
        event.setRequestMethod(request.getMethodValue());
        String path = request.getPath().pathWithinApplication().value();
        MultiValueMap queryParams = request.getQueryParams();
        String requestUrl = UriComponentsBuilder.fromPath((String)path).queryParams(queryParams).build().toUriString();
        event.setRequestUrl(requestUrl);
        event.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
        event.setExceptionName(error.getClass().getName());
        event.setMessage(error.getMessage());
        event.setCreatedAt(LocalDateTime.now());
        Object[] elements = error.getStackTrace();
        if (ObjectUtil.isNotEmpty((Object[])elements)) {
            Object element = elements[0];
            event.setClassName(((StackTraceElement)element).getClassName());
            event.setFileName(((StackTraceElement)element).getFileName());
            event.setMethodName(((StackTraceElement)element).getMethodName());
            event.setLineNumber(((StackTraceElement)element).getLineNumber());
        }
        this.publisher.publishEvent((Object)event);
    }

    public MicaExceptionTranslator(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

