/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.error;

import javax.validation.ConstraintViolationException;
import net.dreamlu.mica.common.error.BaseExceptionTranslator;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.bind.support.WebExchangeBindException;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebInputException;
import reactor.core.publisher.Mono;

@Order(value=-2147483648)
@Configuration
@RestControllerAdvice
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class RestExceptionTranslator
extends BaseExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(RestExceptionTranslator.class);

    @ExceptionHandler(value={ServerWebInputException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<R<Object>> handleError(ServerWebInputException e) {
        log.error("\u7f3a\u5c11\u8bf7\u6c42\u53c2\u6570:{}", (Object)e.getMessage());
        MethodParameter parameter = e.getMethodParameter();
        String message = String.format("\u7f3a\u5c11\u5fc5\u8981\u7684\u8bf7\u6c42\u53c2\u6570: %s", parameter.getParameterName());
        return Mono.just((Object)R.fail((IResultCode)SystemCode.PARAM_MISS, (String)message));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<R<Object>> handleError(MethodArgumentNotValidException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage());
        return Mono.just(this.handleError(e.getBindingResult()));
    }

    @ExceptionHandler(value={BindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<R<Object>> handleError(BindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25:{}", (Object)e.getMessage());
        return Mono.just(this.handleError(e.getBindingResult()));
    }

    @ExceptionHandler(value={WebExchangeBindException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<R<Object>> handleError(WebExchangeBindException e) {
        log.error("\u53c2\u6570\u7ed1\u5b9a\u5931\u8d25:{}", (Object)e.getMessage());
        return Mono.just(this.handleError(e.getBindingResult()));
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<R<Object>> handleError(ConstraintViolationException e) {
        log.error("\u53c2\u6570\u9a8c\u8bc1\u5931\u8d25:{}", (Object)e.getMessage());
        return Mono.just(this.handleError(e.getConstraintViolations()));
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    public Mono<ResponseEntity<R<Object>>> handleError(ResponseStatusException e) {
        log.error("\u54cd\u5e94\u72b6\u6001\u5f02\u5e38:{}", (Object)e.getMessage());
        ResponseEntity entity = ResponseEntity.status((HttpStatus)e.getStatus()).body((Object)R.fail((IResultCode)SystemCode.REQ_REJECT, (String)e.getMessage()));
        return Mono.just((Object)entity);
    }
}

