/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.reactive.logger;

import java.util.ArrayList;
import java.util.Collection;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.launcher.MicaLogLevel;
import net.dreamlu.mica.props.MicaRequestLogProperties;
import net.dreamlu.mica.reactive.logger.RequestLogExclusiveRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class ReactiveRequestLogFilter
implements WebFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(ReactiveRequestLogFilter.class);
    private final MicaRequestLogProperties properties;
    private final RequestLogExclusiveRule exclusiveRule;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        MicaLogLevel level = this.properties.getLevel();
        if (MicaLogLevel.NONE == level) {
            return chain.filter(exchange);
        }
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getPath().pathWithinApplication().value();
        if (this.exclusiveRule.excluded(path)) {
            return chain.filter(exchange);
        }
        MultiValueMap queryParams = request.getQueryParams();
        String requestUrl = UriComponentsBuilder.fromPath((String)path).queryParams(queryParams).build().toUriString();
        StringBuilder beforeReqLog = new StringBuilder(300);
        ArrayList<String> beforeReqArgs = new ArrayList<String>();
        beforeReqLog.append("\n\n================ WebFlux Request Start  ================\n");
        beforeReqLog.append("===> {}: {}\n");
        String requestMethod = request.getMethodValue();
        beforeReqArgs.add(requestMethod);
        beforeReqArgs.add(requestUrl);
        if (MicaLogLevel.HEADERS.lte(level)) {
            HttpHeaders headers = request.getHeaders();
            headers.forEach((headerName, headerValue) -> {
                beforeReqLog.append("===Headers===  {}: {}\n");
                beforeReqArgs.add((String)headerName);
                beforeReqArgs.add(StringUtil.join((Collection)headerValue));
            });
        }
        beforeReqLog.append("================  WebFlux Request End  =================\n");
        log.info(beforeReqLog.toString(), beforeReqArgs.toArray());
        return chain.filter(exchange);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public ReactiveRequestLogFilter(MicaRequestLogProperties properties, RequestLogExclusiveRule exclusiveRule) {
        this.properties = properties;
        this.exclusiveRule = exclusiveRule;
    }
}

