/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.cache;

import java.util.Objects;
import net.dreamlu.mica.servlet.cache.MicaHttpCacheProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class HttpCacheService
implements InitializingBean {
    private final MicaHttpCacheProperties properties;
    private final CacheManager cacheManager;
    private Cache cache;

    public HttpCacheService(MicaHttpCacheProperties properties, CacheManager cacheManager) {
        this.properties = properties;
        this.cacheManager = cacheManager;
    }

    public boolean get(String key) {
        Boolean result = (Boolean)this.cache.get((Object)key, Boolean.class);
        return Boolean.TRUE.equals(result);
    }

    public void set(String key) {
        this.cache.put((Object)key, (Object)Boolean.TRUE);
    }

    public void remove(String key) {
        this.cache.evict((Object)key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.cacheManager, "cacheManager must not be null!");
        String cacheName = this.properties.getCacheName();
        this.cache = this.cacheManager.getCache(cacheName);
        Objects.requireNonNull(this.cache, "HttpCacheCache cacheName: " + cacheName + " is not config.");
    }
}

