/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.dreamlu.mica.core.jackson.MappingApiJackson2HttpMessageConverter;
import net.dreamlu.mica.props.MicaJacksonProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaMessageConfiguration
implements WebMvcConfigurer {
    private final MicaJacksonProperties properties;
    private final ObjectMapper objectMapper;

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.removeIf(x -> x instanceof StringHttpMessageConverter || x instanceof AbstractJackson2HttpMessageConverter);
        converters.add((HttpMessageConverter<?>)new StringHttpMessageConverter(StandardCharsets.UTF_8));
        if (this.properties.getNullToEmpty().booleanValue()) {
            converters.add((HttpMessageConverter<?>)new MappingApiJackson2HttpMessageConverter(this.objectMapper));
        } else {
            converters.add((HttpMessageConverter<?>)new MappingJackson2HttpMessageConverter(this.objectMapper));
        }
    }

    public MicaMessageConfiguration(MicaJacksonProperties properties, ObjectMapper objectMapper) {
        this.properties = properties;
        this.objectMapper = objectMapper;
    }
}

