/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.error;

import java.util.Map;
import java.util.Optional;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.lang.Nullable;
import org.springframework.web.context.request.WebRequest;

public class MicaErrorAttributes
extends DefaultErrorAttributes {
    private static final Logger log = LoggerFactory.getLogger(MicaErrorAttributes.class);

    public Map<String, Object> getErrorAttributes(WebRequest webRequest, boolean includeStackTrace) {
        R result;
        String requestUrl = (String)this.getAttr(webRequest, "javax.servlet.error.request_uri");
        Integer status = (Integer)this.getAttr(webRequest, "javax.servlet.error.status_code");
        Throwable error = this.getError(webRequest);
        if (error == null) {
            log.error("URL:{} error status:{}", (Object)requestUrl, (Object)status);
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)("\u7cfb\u7edf\u672a\u77e5\u5f02\u5e38[HttpStatus]:" + status));
        } else if (error instanceof ServiceException) {
            log.error("URL:{} error status:{}", new Object[]{requestUrl, status, error});
            result = ((ServiceException)error).getResult();
            result = Optional.ofNullable(result).orElse(R.fail((IResultCode)SystemCode.FAILURE));
        } else {
            log.error("URL:{} error status:{}", new Object[]{requestUrl, status, error});
            result = R.fail((IResultCode)SystemCode.FAILURE);
        }
        return BeanUtil.toMap((Object)result);
    }

    @Nullable
    private <T> T getAttr(WebRequest webRequest, String name) {
        return (T)webRequest.getAttribute(name, 0);
    }
}

