/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.error;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.Servlet;
import net.dreamlu.mica.servlet.error.MicaErrorAttributes;
import net.dreamlu.mica.servlet.error.MicaErrorController;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.web.servlet.error.DefaultErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.DispatcherServlet;

@Configuration
@AutoConfigureBefore(value={ErrorMvcAutoConfiguration.class})
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaErrorAutoConfiguration {
    private final ServerProperties serverProperties;
    private final ObjectMapper objectMapper;

    @Bean
    @ConditionalOnMissingBean(value={ErrorAttributes.class}, search=SearchStrategy.CURRENT)
    public DefaultErrorAttributes errorAttributes() {
        return new MicaErrorAttributes();
    }

    @Bean
    @ConditionalOnMissingBean(value={ErrorController.class}, search=SearchStrategy.CURRENT)
    public BasicErrorController basicErrorController(ErrorAttributes errorAttributes) {
        return new MicaErrorController(this.objectMapper, errorAttributes, this.serverProperties.getError());
    }

    public MicaErrorAutoConfiguration(ServerProperties serverProperties, ObjectMapper objectMapper) {
        this.serverProperties = serverProperties;
        this.objectMapper = objectMapper;
    }
}

