/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.error;

import java.time.LocalDateTime;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import net.dreamlu.mica.common.error.MicaErrorEvent;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import net.dreamlu.mica.core.result.SystemCode;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.utils.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;

@Order
@Configuration
@RestControllerAdvice
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MicaExceptionTranslator {
    private static final Logger log = LoggerFactory.getLogger(MicaExceptionTranslator.class);
    private final ApplicationEventPublisher publisher;

    @ExceptionHandler(value={ServiceException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(ServiceException e) {
        log.error("\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
        R result = e.getResult();
        if (result == null) {
            result = R.fail((IResultCode)SystemCode.FAILURE, (String)e.getMessage());
            this.publishEvent((Throwable)e);
        }
        return result;
    }

    @ExceptionHandler(value={Throwable.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public R<Object> handleError(Throwable e) {
        log.error("\u672a\u77e5\u5f02\u5e38", e);
        this.publishEvent(e);
        return R.fail((IResultCode)SystemCode.FAILURE);
    }

    private void publishEvent(Throwable error) {
        MicaErrorEvent event = new MicaErrorEvent();
        HttpServletRequest request = WebUtil.getRequest();
        event.setRequestMethod(request.getMethod());
        String requestUrl = request.getRequestURI();
        String queryString = request.getQueryString();
        if (StringUtil.isNotBlank((CharSequence)queryString)) {
            requestUrl = requestUrl + "?" + queryString;
        }
        event.setRequestUrl(requestUrl);
        event.setStackTrace(Exceptions.getStackTraceAsString((Throwable)error));
        event.setExceptionName(error.getClass().getName());
        event.setMessage(error.getMessage());
        event.setCreatedAt(LocalDateTime.now());
        Object[] elements = error.getStackTrace();
        if (ObjectUtil.isNotEmpty((Object[])elements)) {
            Object element = elements[0];
            event.setClassName(((StackTraceElement)element).getClassName());
            event.setFileName(((StackTraceElement)element).getFileName());
            event.setMethodName(((StackTraceElement)element).getMethodName());
            event.setLineNumber(((StackTraceElement)element).getLineNumber());
        }
        this.publisher.publishEvent((Object)event);
    }

    public MicaExceptionTranslator(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

