/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.servlet.logger;

import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.dreamlu.mica.core.utils.ClassUtil;
import net.dreamlu.mica.core.utils.JsonUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import net.dreamlu.mica.core.utils.WebUtil;
import net.dreamlu.mica.launcher.MicaLogLevel;
import net.dreamlu.mica.props.MicaRequestLogProperties;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.MethodParameter;
import org.springframework.core.io.InputStreamSource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Configuration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(value={"mica.log.request.enabled"}, havingValue="true", matchIfMissing=true)
public class RequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);
    private final MicaRequestLogProperties properties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(!static net.dreamlu.mica.core.result.R *(..)) && (@within(org.springframework.stereotype.Controller) || @within(org.springframework.web.bind.annotation.RestController))")
    public Object aroundApi(ProceedingJoinPoint point) throws Throwable {
        MicaLogLevel level = this.properties.getLevel();
        if (MicaLogLevel.NONE == level) {
            return point.proceed();
        }
        HttpServletRequest request = WebUtil.getRequest();
        String requestUrl = request.getRequestURI();
        String requestMethod = request.getMethod();
        StringBuilder beforeReqLog = new StringBuilder(300);
        ArrayList<Object> beforeReqArgs = new ArrayList<Object>();
        beforeReqLog.append("\n\n================  Request Start  ================\n");
        beforeReqLog.append("===> {}: {}");
        beforeReqArgs.add(requestMethod);
        beforeReqArgs.add(requestUrl);
        this.logIngArgs(point, beforeReqLog, beforeReqArgs);
        this.logIngHeaders(request, level, beforeReqLog, beforeReqArgs);
        beforeReqLog.append("================   Request End   ================\n");
        long startNs = System.nanoTime();
        log.info(beforeReqLog.toString(), beforeReqArgs.toArray());
        StringBuilder afterReqLog = new StringBuilder(200);
        ArrayList<Object> afterReqArgs = new ArrayList<Object>();
        afterReqLog.append("\n\n================  Response Start  ================\n");
        try {
            Object result = point.proceed();
            if (MicaLogLevel.BODY.lte(level)) {
                afterReqLog.append("===Result===  {}\n");
                afterReqArgs.add(JsonUtil.toJson((Object)result));
            }
            Object object = result;
            return object;
        }
        finally {
            long tookMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
            afterReqLog.append("<=== {}: {} ({} ms)\n");
            afterReqArgs.add(requestMethod);
            afterReqArgs.add(requestUrl);
            afterReqArgs.add(tookMs);
            afterReqLog.append("================   Response End   ================\n");
            log.info(afterReqLog.toString(), afterReqArgs.toArray());
        }
    }

    public void logIngArgs(ProceedingJoinPoint point, StringBuilder beforeReqLog, List<Object> beforeReqArgs) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        Object[] args = point.getArgs();
        HashMap<String, Object> paraMap = new HashMap<String, Object>(16);
        Object requestBodyValue = null;
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = ClassUtil.getMethodParameter((Method)method, (int)i);
            PathVariable pathVariable = (PathVariable)methodParam.getParameterAnnotation(PathVariable.class);
            if (pathVariable != null) continue;
            RequestBody requestBody = (RequestBody)methodParam.getParameterAnnotation(RequestBody.class);
            String parameterName = methodParam.getParameterName();
            Object value = args[i];
            if (requestBody != null) {
                requestBodyValue = value;
                continue;
            }
            if (value instanceof HttpServletRequest) {
                paraMap.putAll(((HttpServletRequest)value).getParameterMap());
                continue;
            }
            if (value instanceof WebRequest) {
                paraMap.putAll(((WebRequest)value).getParameterMap());
                continue;
            }
            if (value instanceof HttpServletResponse) continue;
            if (value instanceof MultipartFile) {
                MultipartFile multipartFile = (MultipartFile)value;
                String name = multipartFile.getName();
                String fileName = multipartFile.getOriginalFilename();
                paraMap.put(name, fileName);
                continue;
            }
            RequestParam requestParam = (RequestParam)methodParam.getParameterAnnotation(RequestParam.class);
            String paraName = parameterName;
            if (requestParam != null && StringUtil.isNotBlank((CharSequence)requestParam.value())) {
                paraName = requestParam.value();
            }
            if (value == null) {
                paraMap.put(paraName, null);
                continue;
            }
            if (ClassUtil.isPrimitiveOrWrapper(value.getClass())) {
                paraMap.put(paraName, value);
                continue;
            }
            if (value instanceof InputStream) {
                paraMap.put(paraName, "InputStream");
                continue;
            }
            if (value instanceof InputStreamSource) {
                paraMap.put(paraName, "InputStreamSource");
                continue;
            }
            if (JsonUtil.canSerialize((Object)value)) {
                paraMap.put(paraName, value);
                continue;
            }
            paraMap.put(paraName, "\u3010\u6ce8\u610f\u3011\u4e0d\u80fd\u5e8f\u5217\u5316\u4e3ajson");
        }
        if (paraMap.isEmpty()) {
            beforeReqLog.append("\n");
        } else {
            beforeReqLog.append(" Parameters: {}\n");
            beforeReqArgs.add(JsonUtil.toJson(paraMap));
        }
        if (requestBodyValue != null) {
            beforeReqLog.append("====Body=====  {}\n");
            beforeReqArgs.add(JsonUtil.toJson(requestBodyValue));
        }
    }

    public void logIngHeaders(HttpServletRequest request, MicaLogLevel level, StringBuilder beforeReqLog, List<Object> beforeReqArgs) {
        if (MicaLogLevel.HEADERS.lte(level)) {
            Enumeration headers = request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String headerName = (String)headers.nextElement();
                String headerValue = request.getHeader(headerName);
                beforeReqLog.append("===Headers===  {}: {}\n");
                beforeReqArgs.add(headerName);
                beforeReqArgs.add(headerValue);
            }
        }
    }

    public RequestLogAspect(MicaRequestLogProperties properties) {
        this.properties = properties;
    }
}

