/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.cache;

import java.util.Objects;
import net.dreamlu.mica.captcha.cache.ICaptchaCache;
import net.dreamlu.mica.captcha.config.MicaCaptchaProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheCaptchaCache
implements ICaptchaCache,
InitializingBean {
    private final MicaCaptchaProperties properties;
    private final CacheManager cacheManager;

    @Override
    public void put(String cacheName, String uuid, String value) {
        Cache captchaCache = this.getCache(cacheName);
        captchaCache.put((Object)uuid, (Object)value);
    }

    @Override
    public String getAndRemove(String cacheName, String uuid) {
        Cache captchaCache = this.getCache(cacheName);
        String value = (String)captchaCache.get((Object)uuid, String.class);
        if (value != null) {
            captchaCache.evict((Object)uuid);
        }
        return value;
    }

    private Cache getCache(String cacheName) {
        return this.cacheManager.getCache(cacheName);
    }

    public void afterPropertiesSet() throws Exception {
        String cacheName = this.properties.getCacheName();
        Cache cache = this.cacheManager.getCache(cacheName);
        Objects.requireNonNull(cache, "mica-captcha spring cache name " + cacheName + " is null.");
    }

    public SpringCacheCaptchaCache(MicaCaptchaProperties properties, CacheManager cacheManager) {
        this.properties = properties;
        this.cacheManager = cacheManager;
    }
}

