/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.config;

import net.dreamlu.mica.captcha.cache.ICaptchaCache;
import net.dreamlu.mica.captcha.config.MicaCaptchaProperties;
import net.dreamlu.mica.captcha.core.Captcha;
import net.dreamlu.mica.captcha.service.CaptchaServiceImpl;
import net.dreamlu.mica.captcha.service.ICaptchaService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.nativex.hint.NativeHint;
import org.springframework.nativex.hint.ResourceHint;

@AutoConfiguration
@ConditionalOnProperty(prefix="mica.captcha", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={MicaCaptchaProperties.class})
@NativeHint(resources={@ResourceHint(patterns={"^fonts/.*.ttf"})})
public class MicaCaptchaAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public Captcha imageCaptcha(MicaCaptchaProperties properties) {
        return new Captcha(properties.getCaptchaType());
    }

    @Bean
    @ConditionalOnMissingBean
    public ICaptchaService imageCaptchaService(MicaCaptchaProperties properties, ICaptchaCache captchaCache, Captcha captcha) {
        return new CaptchaServiceImpl(properties, captchaCache, captcha);
    }
}

