/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.core;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import java.util.function.Supplier;
import net.dreamlu.mica.captcha.core.ICaptcha;
import net.dreamlu.mica.captcha.draw.BackgroundDraw;
import net.dreamlu.mica.captcha.draw.CaptchaDraw;
import net.dreamlu.mica.captcha.draw.CurveInterferenceDraw;
import net.dreamlu.mica.captcha.draw.InterferenceDraw;
import net.dreamlu.mica.captcha.draw.RandomCaptchaDraw;
import net.dreamlu.mica.captcha.draw.SmallCharsBackgroundDraw;
import net.dreamlu.mica.captcha.enums.CaptchaType;
import net.dreamlu.mica.core.utils.Holder;
import org.springframework.core.io.ClassPathResource;

public class Captcha
implements ICaptcha {
    private static final int WIDTH = 130;
    private static final int HEIGHT = 48;
    private static final String[] FONT_NAMES = new String[]{"001.ttf", "002.ttf", "003.ttf", "004.ttf"};
    private BackgroundDraw backgroundDraw;
    private CaptchaDraw captchaDraw;
    private InterferenceDraw interferenceDraw;
    private Random random;
    private final Font[] fonts;

    public Captcha() {
        this(new RandomCaptchaDraw());
    }

    public Captcha(CaptchaType type) {
        this(type.getCaptchaDraw());
    }

    public Captcha(CaptchaDraw captchaDraw) {
        this(SmallCharsBackgroundDraw.INSTANCE, captchaDraw, CurveInterferenceDraw.INSTANCE, Holder.SECURE_RANDOM);
    }

    public Captcha(BackgroundDraw backgroundDraw, CaptchaDraw captchaDraw, InterferenceDraw interferenceDraw, Random random) {
        this.backgroundDraw = backgroundDraw;
        this.captchaDraw = captchaDraw;
        this.interferenceDraw = interferenceDraw;
        this.random = random;
        this.fonts = Captcha.loadFonts();
    }

    public void setBackgroundDraw(BackgroundDraw backgroundDraw) {
        this.backgroundDraw = Objects.requireNonNull(backgroundDraw, "BackgroundDraw is null.");
    }

    public void setCaptchaDraw(CaptchaDraw captchaDraw) {
        this.captchaDraw = Objects.requireNonNull(captchaDraw, "CaptchaDraw is null.");
    }

    public void setInterferenceDraw(InterferenceDraw interferenceDraw) {
        this.interferenceDraw = Objects.requireNonNull(interferenceDraw, "InterferenceDraw is null.");
    }

    public void setRandom(Random random) {
        this.random = Objects.requireNonNull(random, "Random is null.");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String generate(Supplier<OutputStream> supplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean validate(String code, String userInputCaptcha) {
        return this.captchaDraw.validate(code, userInputCaptcha);
    }

    private static Graphics2D initGraphics(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return graphics;
    }

    private static Font[] loadFonts() {
        ArrayList<Font> fontList = new ArrayList<Font>();
        for (String fontName : FONT_NAMES) {
            String path = "fonts/" + fontName;
            fontList.add(Captcha.loadFont(new ClassPathResource(path)));
        }
        return fontList.toArray(new Font[0]);
    }

    private static Font loadFont(ClassPathResource resource) {
        return Font.createFont(0, resource.getInputStream());
    }
}

