/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.core;

import java.awt.Color;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Random;
import org.springframework.boot.convert.DurationStyle;

public class CaptchaUtil {
    public static long getTTLFormCacheName(String cacheName) {
        String[] cacheArray = cacheName.split("#");
        if (cacheArray.length < 2) {
            return -1L;
        }
        Duration duration = DurationStyle.detectAndParse((String)cacheArray[1], (ChronoUnit)ChronoUnit.SECONDS);
        return duration.toMillis();
    }

    public static int randNum(Random random, int min, int max) {
        int diff = max - min;
        int rand = random.nextInt(diff);
        return min + rand;
    }

    public static Color randColor(Random random, int fc, int bc) {
        int colorMax = 255;
        if (fc > colorMax) {
            fc = 255;
        }
        if (bc > colorMax) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }
}

