/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.draw;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.CubicCurve2D;
import java.util.Random;
import net.dreamlu.mica.captcha.core.CaptchaUtil;
import net.dreamlu.mica.captcha.draw.InterferenceDraw;

public enum CurveInterferenceDraw implements InterferenceDraw
{
    INSTANCE;


    @Override
    public void draw(Graphics2D g, int width, int height, Font[] fonts, Random random) {
        g.setStroke(new BasicStroke(1.8f));
        int x1 = 5;
        int y1 = CaptchaUtil.randNum(random, 5, height / 2);
        int maxHeight = height - 5;
        int minWidth = width / 4;
        int maxWidth = width / 4 * 3;
        int ctrLx1 = CaptchaUtil.randNum(random, minWidth, maxWidth);
        int ctrLy1 = CaptchaUtil.randNum(random, 5, maxHeight);
        int ctrLx2 = CaptchaUtil.randNum(random, minWidth, maxWidth);
        int ctrLy2 = CaptchaUtil.randNum(random, 5, maxHeight);
        int x2 = width - 5;
        int y2 = CaptchaUtil.randNum(random, height / 2, maxHeight);
        g.draw(new CubicCurve2D.Double(x1, y1, ctrLx1, ctrLy1, ctrLx2, ctrLy2, x2, y2));
    }
}

