/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.draw;

import java.util.Random;
import net.dreamlu.mica.captcha.core.CaptchaUtil;

class Expression {
    private static final char PLUS = '+';
    private static final char MINUS = '-';
    private static final char MULTIPLY = '\u00d7';

    Expression() {
    }

    public static int eval(String expr) {
        char[] chars = expr.toCharArray();
        int length = expr.length();
        for (int i = 0; i < chars.length; ++i) {
            char operator = chars[i];
            if ('+' != operator && '-' != operator && '\u00d7' != operator) continue;
            int num1 = Expression.findInt(expr, 0, i);
            int num2 = Expression.findInt(expr, i + 1, length);
            return Expression.eval(num1, operator, num2);
        }
        return -1;
    }

    private static int eval(int num1, char operator, int num2) {
        switch (operator) {
            case '+': {
                return num1 + num2;
            }
            case '-': {
                return num1 - num2;
            }
            case '\u00d7': {
                return num1 * num2;
            }
        }
        return -1;
    }

    public static String randomExpr(Random random) {
        int num2;
        int num1;
        char[] chars = new char[]{'+', '-', '\u00d7'};
        char operator = chars[random.nextInt(chars.length)];
        if ('\u00d7' == operator) {
            num1 = CaptchaUtil.randNum(random, 1, 10);
            num2 = CaptchaUtil.randNum(random, 1, 10);
        } else {
            num1 = CaptchaUtil.randNum(random, 1, 20);
            num2 = CaptchaUtil.randNum(random, 1, 20);
        }
        if ('-' == operator && num2 > num1) {
            int num = num1;
            num1 = num2;
            num2 = num;
        }
        return String.valueOf(num1) + operator + num2;
    }

    private static int findInt(String expr, int start, int end) {
        return Integer.parseInt(expr.substring(start, end));
    }
}

