/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.draw;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Random;
import net.dreamlu.mica.captcha.core.CaptchaUtil;
import net.dreamlu.mica.captcha.draw.CaptchaDraw;
import net.dreamlu.mica.captcha.draw.Expression;
import net.dreamlu.mica.core.utils.StringUtil;

public class MathCaptchaDraw
implements CaptchaDraw {
    @Override
    public String draw(Graphics2D g, int width, int height, Font[] fonts, Random random) {
        Font fontTemp = fonts[random.nextInt(fonts.length)];
        g.setColor(CaptchaUtil.randColor(random, 0, 100));
        String expr = Expression.randomExpr(random);
        String text = expr + "=?";
        int len = text.length();
        Font font = fontTemp.deriveFont(1, ((float)width - 10.0f) / (float)len * 1.6f);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = 0;
        for (int i = 0; i < len; ++i) {
            char charAt = text.charAt(i);
            int charWidth = fontMetrics.charWidth(charAt);
            textWidth += charWidth;
        }
        float x = (float)(width - textWidth) / 2.0f;
        float y = (float)height / 4.0f * 3.0f;
        g.drawString(text, x, y);
        return expr;
    }

    @Override
    public boolean validate(String code, String userInputCaptcha) {
        int evalNum;
        if (!StringUtil.isNumeric((CharSequence)userInputCaptcha)) {
            return false;
        }
        int captchaNum = Integer.parseInt(userInputCaptcha);
        return captchaNum == (evalNum = Expression.eval(code));
    }
}

