/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.draw;

import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Random;
import net.dreamlu.mica.captcha.core.CaptchaUtil;
import net.dreamlu.mica.captcha.draw.CaptchaDraw;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.util.ObjectUtils;

public class RandomCaptchaDraw
implements CaptchaDraw {
    private static final int CODE_SIZE = 4;
    private static final char[] CHAR_ARRAY = "3456789ABCDEFGHJKMNPQRSTUVWXY".toCharArray();
    private final int codeSize;

    public RandomCaptchaDraw() {
        this(4);
    }

    public RandomCaptchaDraw(int codeSize) {
        this.codeSize = codeSize;
    }

    @Override
    public String draw(Graphics2D g, int width, int height, Font[] fonts, Random random) {
        String code = RandomCaptchaDraw.generateCode(random, this.codeSize);
        char[] buffer = code.toCharArray();
        for (int i = 0; i < buffer.length; ++i) {
            int degree = random.nextInt(25);
            if (i % 2 == 0) {
                degree = -degree;
            }
            int x = 27 * i;
            int y = 28;
            double radians = Math.toRadians(degree);
            g.rotate(radians, x, y);
            g.setColor(CaptchaUtil.randColor(random, 20, 130));
            Font fontTemp = fonts[random.nextInt(fonts.length)];
            Font font = fontTemp.deriveFont(1, ((float)width - 10.0f) / (float)this.codeSize * 1.2f);
            g.setFont(font);
            char xcode = buffer[i];
            g.drawString(String.valueOf(xcode), x + 8, y + 10);
            g.rotate(-radians, x, y);
        }
        return code;
    }

    private static String generateCode(Random random, int size) {
        char[] buffer = new char[size];
        for (int i = 0; i < size; ++i) {
            buffer[i] = CHAR_ARRAY[random.nextInt(CHAR_ARRAY.length)];
        }
        return new String(buffer);
    }

    @Override
    public boolean validate(String code, String userInputCaptcha) {
        if (StringUtil.isBlank((CharSequence)userInputCaptcha)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)code, (Object)userInputCaptcha.toUpperCase());
    }
}

