/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.draw;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.Random;
import net.dreamlu.mica.captcha.core.CaptchaUtil;
import net.dreamlu.mica.captcha.draw.BackgroundDraw;

public enum SmallCharsBackgroundDraw implements BackgroundDraw
{
    INSTANCE;

    private static final char[] CHAR_ARRAY;

    @Override
    public void draw(Graphics2D g, int width, int height, Font[] fonts, Random random) {
        Font fontTemp = fonts[random.nextInt(fonts.length)];
        g.setColor(CaptchaUtil.randColor(random, 220, 250));
        g.fillRect(0, 0, width, height);
        Font font = fontTemp.deriveFont(0, 16.0f);
        g.setFont(font);
        FontMetrics fontMetrics = g.getFontMetrics();
        int charCount = 10;
        for (int i = 0; i < charCount; ++i) {
            g.setColor(CaptchaUtil.randColor(random, 120, 200));
            char ch = CHAR_ARRAY[random.nextInt(CHAR_ARRAY.length)];
            int offset = fontMetrics.charWidth(ch);
            int x = CaptchaUtil.randNum(random, offset, width - offset);
            int y = CaptchaUtil.randNum(random, offset, height - offset);
            g.drawString(String.valueOf(ch), x, y);
        }
    }

    static {
        CHAR_ARRAY = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }
}

