/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.service;

import java.io.OutputStream;
import net.dreamlu.mica.captcha.cache.ICaptchaCache;
import net.dreamlu.mica.captcha.config.MicaCaptchaProperties;
import net.dreamlu.mica.captcha.core.Captcha;
import net.dreamlu.mica.captcha.service.ICaptchaService;
import net.dreamlu.mica.core.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaServiceImpl
implements ICaptchaService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaServiceImpl.class);
    private final MicaCaptchaProperties properties;
    private final ICaptchaCache captchaCache;
    private final Captcha captcha;

    @Override
    public void generate(String uuid, OutputStream outputStream) {
        String generate = this.captcha.generate(() -> outputStream);
        this.captchaCache.put(this.properties.getCacheName(), uuid, generate);
    }

    @Override
    public boolean validate(String uuid, String userInputCaptcha) {
        log.debug("validate captcha uuid is {}, userInputCaptcha is {}", (Object)uuid, (Object)userInputCaptcha);
        String code = this.captchaCache.getAndRemove(this.properties.getCacheName(), uuid);
        if (StringUtil.isBlank((CharSequence)code)) {
            return false;
        }
        return this.captcha.validate(code, userInputCaptcha);
    }

    public CaptchaServiceImpl(MicaCaptchaProperties properties, ICaptchaCache captchaCache, Captcha captcha) {
        this.properties = properties;
        this.captchaCache = captchaCache;
        this.captcha = captcha;
    }
}

