/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.captcha.service;

import java.io.OutputStream;
import net.dreamlu.mica.captcha.vo.CaptchaVo;
import net.dreamlu.mica.core.utils.Base64Util;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.MultiValueMap;

public interface ICaptchaService {
    public void generate(String var1, OutputStream var2);

    default public byte[] generateBytes(String uuid) {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        this.generate(uuid, (OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    default public ByteArrayResource generateByteResource(String uuid) {
        return new ByteArrayResource(this.generateBytes(uuid));
    }

    default public String generateBase64(String uuid) {
        FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();
        this.generate(uuid, (OutputStream)outputStream);
        return "data:image/jpeg;base64," + Base64Util.encodeToString((byte[])outputStream.toByteArray());
    }

    default public CaptchaVo generateBase64Vo() {
        return this.generateBase64Vo(StringUtil.getUUID());
    }

    default public CaptchaVo generateBase64Vo(String uuid) {
        return new CaptchaVo(uuid, this.generateBase64(uuid));
    }

    default public ResponseEntity<Resource> generateResponseEntity(String uuid) {
        return new ResponseEntity((Object)this.generateByteResource(uuid), (MultiValueMap)this.getCaptchaHeaders(), HttpStatus.OK);
    }

    default public HttpHeaders getCaptchaHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setPragma("no-cache");
        headers.setCacheControl("no-cache");
        headers.setExpires(0L);
        headers.setContentType(MediaType.IMAGE_JPEG);
        return headers;
    }

    public boolean validate(String var1, String var2);
}

