/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.exception;

import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.R;
import org.springframework.lang.Nullable;

public class ServiceException
extends RuntimeException {
    private static final long serialVersionUID = 2359767895161832954L;
    @Nullable
    private final R<?> result;

    public ServiceException(R<?> result) {
        super(result.getMsg());
        this.result = result;
    }

    public ServiceException(IResultCode rCode) {
        this(rCode, rCode.getMsg());
    }

    public ServiceException(IResultCode rCode, String message) {
        super(message);
        this.result = R.fail(rCode, message);
    }

    public ServiceException(String message) {
        super(message);
        this.result = null;
    }

    public ServiceException(Throwable cause) {
        this(cause.getMessage(), cause);
    }

    public ServiceException(String message, Throwable cause) {
        super(message, cause);
        this.doFillInStackTrace();
        this.result = null;
    }

    @Nullable
    public <T> R<T> getResult() {
        return this.result;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public Throwable doFillInStackTrace() {
        return super.fillInStackTrace();
    }
}

