/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.jackson;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import net.dreamlu.mica.core.utils.DateUtil;

public class MicaJavaTimeModule
extends SimpleModule {
    public MicaJavaTimeModule() {
        super(PackageVersion.VERSION);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateUtil.DATETIME_FORMATTER));
        this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateUtil.DATE_FORMATTER));
        this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateUtil.TIME_FORMATTER));
        this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateUtil.DATETIME_FORMATTER));
        this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateUtil.DATE_FORMATTER));
        this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateUtil.TIME_FORMATTER));
    }
}

