/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.result;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Optional;
import net.dreamlu.mica.core.exception.ServiceException;
import net.dreamlu.mica.core.result.IResultCode;
import net.dreamlu.mica.core.result.SystemCode;
import org.springframework.lang.Nullable;

@ApiModel(description="\u8fd4\u56de\u4fe1\u606f")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = -1160662278280275915L;
    @ApiModelProperty(value="code\u503c", required=true)
    private int code;
    @ApiModelProperty(value="\u662f\u5426\u6210\u529f", required=true)
    private boolean success;
    @ApiModelProperty(value="\u6d88\u606f", required=true)
    private String msg;
    @ApiModelProperty(value="\u8fd4\u56de\u5bf9\u8c61")
    private T data;

    private R(IResultCode resultCode) {
        this(resultCode, resultCode.getMsg(), null);
    }

    private R(IResultCode resultCode, String msg) {
        this(resultCode, msg, null);
    }

    private R(IResultCode resultCode, T data) {
        this(resultCode, resultCode.getMsg(), data);
    }

    private R(IResultCode resultCode, String msg, T data) {
        this.code = resultCode.getCode();
        this.msg = msg;
        this.data = data;
        this.success = SystemCode.SUCCESS == resultCode;
    }

    public static boolean isSuccess(@Nullable R<?> result) {
        return Optional.ofNullable(result).map(r -> r.code).map(code -> SystemCode.SUCCESS.code == code).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable R<?> result) {
        return !R.isSuccess(result);
    }

    @Nullable
    public static <T> T getData(@Nullable R<T> result) {
        return Optional.ofNullable(result).filter(r -> r.success).map(x -> x.data).orElse(null);
    }

    public static <T> R<T> success() {
        return new R<T>(SystemCode.SUCCESS);
    }

    public static <T> R<T> success(@Nullable T data) {
        return new R<T>((IResultCode)SystemCode.SUCCESS, data);
    }

    public static <T> R<T> status(boolean status, String msg) {
        return status ? R.success() : R.fail(msg);
    }

    public static <T> R<T> status(boolean status, IResultCode sCode) {
        return status ? R.success() : R.fail(sCode);
    }

    public static <T> R<T> fail(String msg) {
        return new R<T>((IResultCode)SystemCode.FAILURE, msg);
    }

    public static <T> R<T> fail(IResultCode rCode) {
        return new R<T>(rCode);
    }

    public static <T> R<T> fail(IResultCode rCode, String msg) {
        return new R<T>(rCode, msg);
    }

    public static void throwOnFail(R<?> result) {
        if (R.isNotSuccess(result)) {
            throw new ServiceException(result);
        }
    }

    public static void throwOnFail(R<?> result, IResultCode rCode) {
        if (R.isNotSuccess(result)) {
            throw new ServiceException(rCode);
        }
    }

    public static void throwOnFail(R<?> result, IResultCode rCode, String msg) {
        if (R.isNotSuccess(result)) {
            throw new ServiceException(rCode, msg);
        }
    }

    public static void throwOnFalse(boolean status, IResultCode rCode) {
        if (!status) {
            throw new ServiceException(rCode);
        }
    }

    public static void throwOnFalse(boolean status, IResultCode rCode, String msg) {
        if (!status) {
            throw new ServiceException(rCode, msg);
        }
    }

    public static void throwFail(IResultCode rCode) {
        throw new ServiceException(rCode);
    }

    public static void throwFail(IResultCode rCode, String message) {
        throw new ServiceException(rCode, message);
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", success=" + this.isSuccess() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public R() {
    }
}

