/*
 * Decompiled with CFR 0.152.
 */
package net.dreamlu.mica.core.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import net.dreamlu.mica.core.jackson.MicaJavaTimeModule;
import net.dreamlu.mica.core.utils.Exceptions;
import net.dreamlu.mica.core.utils.ObjectUtil;
import net.dreamlu.mica.core.utils.StringUtil;
import org.springframework.lang.Nullable;

public final class JsonUtil {
    @Nullable
    public static String toJson(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        try {
            return JsonUtil.getInstance().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] toJsonAsBytes(@Nullable Object object) {
        if (object == null) {
            return new byte[0];
        }
        try {
            return JsonUtil.getInstance().writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(String jsonString) {
        Objects.requireNonNull(jsonString, "jsonString is null");
        try {
            return JsonUtil.getInstance().readTree(jsonString);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        Objects.requireNonNull(in, "InputStream in is null");
        try {
            return JsonUtil.getInstance().readTree(in);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        Objects.requireNonNull(content, "byte[] content is null");
        try {
            return JsonUtil.getInstance().readTree(content);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode readTree(JsonParser jsonParser) {
        Objects.requireNonNull(jsonParser, "jsonParser is null");
        try {
            return (JsonNode)JsonUtil.getInstance().readTree(jsonParser);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, Class<T> valueType) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(content, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, Class<T> valueType) {
        if (StringUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(jsonString, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, Class<T> valueType) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(in, valueType);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable byte[] content, TypeReference<T> typeReference) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(content, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable String jsonString, TypeReference<T> typeReference) {
        if (StringUtil.isBlank(jsonString)) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(jsonString, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    @Nullable
    public static <T> T readValue(@Nullable InputStream in, TypeReference<T> typeReference) {
        if (in == null) {
            return null;
        }
        try {
            return (T)JsonUtil.getInstance().readValue(in, typeReference);
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static MapType getMapType(Class<?> keyClass, Class<?> valueClass) {
        return JsonUtil.getInstance().getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
    }

    public static CollectionLikeType getListType(Class<?> elementClass) {
        return JsonUtil.getInstance().getTypeFactory().constructCollectionLikeType(List.class, elementClass);
    }

    public static <T> List<T> readList(@Nullable byte[] content, Class<T> elementClass) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable InputStream content, Class<T> elementClass) {
        if (content == null) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> List<T> readList(@Nullable String content, Class<T> elementClass) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyList();
        }
        try {
            return (List)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getListType(elementClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable byte[] content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable InputStream content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <K, V> Map<K, V> readMap(@Nullable String content, Class<?> keyClass, Class<?> valueClass) {
        if (ObjectUtil.isEmpty((Object)content)) {
            return Collections.emptyMap();
        }
        try {
            return (Map)JsonUtil.getInstance().readValue(content, (JavaType)JsonUtil.getMapType(keyClass, valueClass));
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, JavaType toValueType) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)JsonUtil.getInstance().convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T treeToValue(TreeNode treeNode, Class<T> valueType) {
        try {
            return (T)JsonUtil.getInstance().treeToValue(treeNode, valueType);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static JsonNode valueToTree(@Nullable Object value) {
        return JsonUtil.getInstance().valueToTree(value);
    }

    public static boolean canSerialize(@Nullable Object value) {
        if (value == null) {
            return true;
        }
        return JsonUtil.getInstance().canSerialize(value.getClass());
    }

    public static ObjectMapper getInstance() {
        return JacksonHolder.INSTANCE;
    }

    private JsonUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class JacksonObjectMapper
    extends ObjectMapper {
        private static final long serialVersionUID = 4288193147502386170L;
        private static final Locale CHINA = Locale.CHINA;

        JacksonObjectMapper() {
            super.setLocale(CHINA);
            super.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", CHINA));
            super.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            super.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
            super.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
            super.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            super.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            super.setTimeZone(TimeZone.getTimeZone(ZoneId.systemDefault()));
            super.findAndRegisterModules();
            super.registerModule((Module)new MicaJavaTimeModule());
        }
    }

    private static class JacksonHolder {
        private static ObjectMapper INSTANCE = new JacksonObjectMapper();

        private JacksonHolder() {
        }
    }
}

